/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.geo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.geo.AbstractGeofencingNode;
import org.thingsboard.rule.engine.geo.TbGpsGeofencingFilterNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="gps geofencing filter", configClazz=TbGpsGeofencingFilterNodeConfiguration.class, relationTypes={"True", "False"}, nodeDescription="Filter incoming messages by GPS based geofencing", nodeDetails="Extracts latitude and longitude parameters from incoming message and returns 'True' if they are inside configured perimeters, 'False' otherwise.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeGpsGeofencingConfig")
public class TbGpsGeofencingFilterNode
extends AbstractGeofencingNode<TbGpsGeofencingFilterNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbGpsGeofencingFilterNode.class);

    public void onMsg(TbContext ctx, TbMsg msg) throws TbNodeException {
        ctx.tellNext(msg, this.checkMatches(msg) ? "True" : "False");
    }

    @Override
    protected Class<TbGpsGeofencingFilterNodeConfiguration> getConfigClazz() {
        return TbGpsGeofencingFilterNodeConfiguration.class;
    }
}

