/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.debug;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.debug.TbMsgGeneratorNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;

@RuleNode(type=ComponentType.ACTION, name="generator", configClazz=TbMsgGeneratorNodeConfiguration.class, nodeDescription="Periodically generates messages", nodeDetails="Generates messages with configurable period. Javascript function used for message generation.", inEnabled=false, uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeGeneratorConfig", icon="repeat")
public class TbMsgGeneratorNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgGeneratorNode.class);
    private static final String TB_MSG_GENERATOR_NODE_MSG = "TbMsgGeneratorNodeMsg";
    private TbMsgGeneratorNodeConfiguration config;
    private ScriptEngine jsEngine;
    private long delay;
    private long lastScheduledTs;
    private int currentMsgCount;
    private EntityId originatorId;
    private UUID nextTickId;
    private TbMsg prevMsg;
    private volatile boolean initialized;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgGeneratorNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgGeneratorNodeConfiguration.class);
        this.delay = TimeUnit.SECONDS.toMillis(this.config.getPeriodInSeconds());
        this.currentMsgCount = 0;
        this.originatorId = !StringUtils.isEmpty((Object)this.config.getOriginatorId()) ? EntityIdFactory.getByTypeAndUuid((EntityType)this.config.getOriginatorType(), (String)this.config.getOriginatorId()) : ctx.getSelfId();
        this.updateGeneratorState(ctx);
    }

    public void onPartitionChangeMsg(TbContext ctx, PartitionChangeMsg msg) {
        this.updateGeneratorState(ctx);
    }

    private void updateGeneratorState(TbContext ctx) {
        if (ctx.isLocalEntity(this.originatorId)) {
            if (!this.initialized) {
                this.initialized = true;
                this.jsEngine = ctx.createJsScriptEngine(this.config.getJsScript(), new String[]{"prevMsg", "prevMetadata", "prevMsgType"});
                this.scheduleTickMsg(ctx);
            }
        } else if (this.initialized) {
            this.initialized = false;
            this.destroy();
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        if (this.initialized && msg.getType().equals(TB_MSG_GENERATOR_NODE_MSG) && msg.getId().equals(this.nextTickId)) {
            DonAsynchron.withCallback(this.generate(ctx), m -> {
                if (this.initialized && (this.config.getMsgCount() == 0 || this.currentMsgCount < this.config.getMsgCount())) {
                    ctx.enqueueForTellNext(m, TbRelationTypes.SUCCESS);
                    this.scheduleTickMsg(ctx);
                    ++this.currentMsgCount;
                }
            }, t -> {
                if (this.initialized) {
                    ctx.tellFailure(msg, t);
                    this.scheduleTickMsg(ctx);
                }
            });
        }
    }

    private void scheduleTickMsg(TbContext ctx) {
        long curTs = System.currentTimeMillis();
        if (this.lastScheduledTs == 0L) {
            this.lastScheduledTs = curTs;
        }
        this.lastScheduledTs += this.delay;
        long curDelay = Math.max(0L, this.lastScheduledTs - curTs);
        TbMsg tickMsg = ctx.newMsg("Main", TB_MSG_GENERATOR_NODE_MSG, (EntityId)ctx.getSelfId(), new TbMsgMetaData(), "");
        this.nextTickId = tickMsg.getId();
        ctx.tellSelf(tickMsg, curDelay);
    }

    private ListenableFuture<TbMsg> generate(TbContext ctx) {
        return ctx.getJsExecutor().executeAsync(() -> {
            if (this.prevMsg == null) {
                this.prevMsg = ctx.newMsg("Main", "", this.originatorId, new TbMsgMetaData(), "{}");
            }
            if (this.initialized) {
                ctx.logJsEvalRequest();
                TbMsg generated = this.jsEngine.executeGenerate(this.prevMsg);
                ctx.logJsEvalResponse();
                this.prevMsg = ctx.newMsg("Main", generated.getType(), this.originatorId, generated.getMetaData(), generated.getData());
            }
            return this.prevMsg;
        });
    }

    public void destroy() {
        this.prevMsg = null;
        if (this.jsEngine != null) {
            this.jsEngine.destroy();
            this.jsEngine = null;
        }
    }
}

