/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbAbstractRelationActionNode;
import org.thingsboard.rule.engine.action.TbCreateRelationNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.util.EntityContainer;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="create relation", configClazz=TbCreateRelationNodeConfiguration.class, nodeDescription="Finds target Entity by entity name pattern and (entity type pattern for Asset, Device) and then create a relation to Originator Entity by type and direction. If Selected entity type: Asset, Device or Customer will create new Entity if it doesn't exist and selected checkbox 'Create new entity if not exists'.<br> In case that relation from the message originator to the selected entity not exist and  If selected checkbox 'Remove current relations', before creating the new relation all existed relations to message originator by type and direction will be removed.<br> If relation from the message originator to the selected entity created and If selected checkbox 'Change originator to related entity', outbound message will be processed as a message from this entity.", nodeDetails="If the relation already exists or successfully created -  Message send via <b>Success</b> chain, otherwise <b>Failure</b> chain will be used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeCreateRelationConfig", icon="add_circle")
public class TbCreateRelationNode
extends TbAbstractRelationActionNode<TbCreateRelationNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbCreateRelationNode.class);

    @Override
    protected TbCreateRelationNodeConfiguration loadEntityNodeActionConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbCreateRelationNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCreateRelationNodeConfiguration.class);
    }

    @Override
    protected boolean createEntityIfNotExists() {
        return ((TbCreateRelationNodeConfiguration)this.config).isCreateEntityIfNotExists();
    }

    @Override
    protected ListenableFuture<TbAbstractRelationActionNode.RelationContainer> doProcessEntityRelationAction(TbContext ctx, TbMsg msg, EntityContainer entity, String relationType) {
        ListenableFuture<Boolean> future = this.createIfAbsent(ctx, msg, entity, relationType);
        return Futures.transform(future, result -> {
            TbAbstractRelationActionNode.RelationContainer container = new TbAbstractRelationActionNode.RelationContainer();
            if (result.booleanValue() && ((TbCreateRelationNodeConfiguration)this.config).isChangeOriginatorToRelatedEntity()) {
                TbMsg tbMsg = ctx.transformMsg(msg, msg.getType(), entity.getEntityId(), msg.getMetaData(), msg.getData());
                container.setMsg(tbMsg);
            } else {
                container.setMsg(msg);
            }
            container.setResult((boolean)result);
            return container;
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> createIfAbsent(TbContext ctx, TbMsg msg, EntityContainer entityContainer, String relationType) {
        TbAbstractRelationActionNode.SearchDirectionIds sdId = this.processSingleSearchDirection(msg, entityContainer);
        ListenableFuture checkRelationFuture = Futures.transformAsync((ListenableFuture)ctx.getRelationService().checkRelation(ctx.getTenantId(), sdId.getFromId(), sdId.getToId(), relationType, RelationTypeGroup.COMMON), result -> {
            if (!result.booleanValue()) {
                if (((TbCreateRelationNodeConfiguration)this.config).isRemoveCurrentRelations()) {
                    return this.processDeleteRelations(ctx, this.processFindRelations(ctx, msg, sdId, relationType));
                }
                return Futures.immediateFuture((Object)false);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
        return Futures.transformAsync((ListenableFuture)checkRelationFuture, result -> {
            if (!result.booleanValue()) {
                return this.processCreateRelation(ctx, entityContainer, sdId, relationType);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<List<EntityRelation>> processFindRelations(TbContext ctx, TbMsg msg, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        if (sdId.isOriginatorDirectionFrom()) {
            return ctx.getRelationService().findByFromAndTypeAsync(ctx.getTenantId(), msg.getOriginator(), relationType, RelationTypeGroup.COMMON);
        }
        return ctx.getRelationService().findByToAndTypeAsync(ctx.getTenantId(), msg.getOriginator(), relationType, RelationTypeGroup.COMMON);
    }

    private ListenableFuture<Boolean> processDeleteRelations(TbContext ctx, ListenableFuture<List<EntityRelation>> listListenableFuture) {
        return Futures.transformAsync(listListenableFuture, entityRelations -> {
            if (!entityRelations.isEmpty()) {
                ArrayList<ListenableFuture> list = new ArrayList<ListenableFuture>();
                for (EntityRelation relation : entityRelations) {
                    list.add(ctx.getRelationService().deleteRelationAsync(ctx.getTenantId(), relation));
                }
                return Futures.transform((ListenableFuture)Futures.allAsList(list), result -> false, (Executor)ctx.getDbCallbackExecutor());
            }
            return Futures.immediateFuture((Object)false);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processCreateRelation(TbContext ctx, EntityContainer entityContainer, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        switch (entityContainer.getEntityType()) {
            case ASSET: {
                return this.processAsset(ctx, entityContainer, sdId, relationType);
            }
            case DEVICE: {
                return this.processDevice(ctx, entityContainer, sdId, relationType);
            }
            case CUSTOMER: {
                return this.processCustomer(ctx, entityContainer, sdId, relationType);
            }
            case DASHBOARD: {
                return this.processDashboard(ctx, entityContainer, sdId, relationType);
            }
            case ENTITY_VIEW: {
                return this.processView(ctx, entityContainer, sdId, relationType);
            }
            case TENANT: {
                return this.processTenant(ctx, entityContainer, sdId, relationType);
            }
        }
        return Futures.immediateFuture((Object)true);
    }

    private ListenableFuture<Boolean> processView(TbContext ctx, EntityContainer entityContainer, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        return Futures.transformAsync((ListenableFuture)ctx.getEntityViewService().findEntityViewByIdAsync(ctx.getTenantId(), new EntityViewId(entityContainer.getEntityId().getId())), entityView -> {
            if (entityView != null) {
                return this.processSave(ctx, sdId, relationType);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processDevice(TbContext ctx, EntityContainer entityContainer, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        return Futures.transformAsync((ListenableFuture)ctx.getDeviceService().findDeviceByIdAsync(ctx.getTenantId(), new DeviceId(entityContainer.getEntityId().getId())), device -> {
            if (device != null) {
                return this.processSave(ctx, sdId, relationType);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processAsset(TbContext ctx, EntityContainer entityContainer, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        return Futures.transformAsync((ListenableFuture)ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), new AssetId(entityContainer.getEntityId().getId())), asset -> {
            if (asset != null) {
                return this.processSave(ctx, sdId, relationType);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processCustomer(TbContext ctx, EntityContainer entityContainer, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        return Futures.transformAsync((ListenableFuture)ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), new CustomerId(entityContainer.getEntityId().getId())), customer -> {
            if (customer != null) {
                return this.processSave(ctx, sdId, relationType);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processDashboard(TbContext ctx, EntityContainer entityContainer, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        return Futures.transformAsync((ListenableFuture)ctx.getDashboardService().findDashboardByIdAsync(ctx.getTenantId(), new DashboardId(entityContainer.getEntityId().getId())), dashboard -> {
            if (dashboard != null) {
                return this.processSave(ctx, sdId, relationType);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processTenant(TbContext ctx, EntityContainer entityContainer, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        return Futures.transformAsync((ListenableFuture)ctx.getTenantService().findTenantByIdAsync(ctx.getTenantId(), new TenantId(entityContainer.getEntityId().getId())), tenant -> {
            if (tenant != null) {
                return this.processSave(ctx, sdId, relationType);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processSave(TbContext ctx, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        return ctx.getRelationService().saveRelationAsync(ctx.getTenantId(), new EntityRelation(sdId.getFromId(), sdId.getToId(), relationType, RelationTypeGroup.COMMON));
    }
}

