/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import java.util.Collections;
import java.util.List;
import org.thingsboard.rule.engine.action.TbAbstractAlarmNodeConfiguration;
import org.thingsboard.rule.engine.api.NodeConfiguration;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;

public class TbCreateAlarmNodeConfiguration
extends TbAbstractAlarmNodeConfiguration
implements NodeConfiguration<TbCreateAlarmNodeConfiguration> {
    private AlarmSeverity severity;
    private boolean propagate;
    private boolean useMessageAlarmData;
    private List<String> relationTypes;

    public TbCreateAlarmNodeConfiguration defaultConfiguration() {
        TbCreateAlarmNodeConfiguration configuration = new TbCreateAlarmNodeConfiguration();
        configuration.setAlarmDetailsBuildJs("var details = {};\nif (metadata.prevAlarmDetails) {\n    details = JSON.parse(metadata.prevAlarmDetails);\n}\nreturn details;");
        configuration.setAlarmType("General Alarm");
        configuration.setSeverity(AlarmSeverity.CRITICAL);
        configuration.setPropagate(false);
        configuration.setUseMessageAlarmData(false);
        configuration.setRelationTypes(Collections.emptyList());
        return configuration;
    }

    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    public boolean isUseMessageAlarmData() {
        return this.useMessageAlarmData;
    }

    public List<String> getRelationTypes() {
        return this.relationTypes;
    }

    public void setSeverity(AlarmSeverity severity) {
        this.severity = severity;
    }

    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    public void setUseMessageAlarmData(boolean useMessageAlarmData) {
        this.useMessageAlarmData = useMessageAlarmData;
    }

    public void setRelationTypes(List<String> relationTypes) {
        this.relationTypes = relationTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbCreateAlarmNodeConfiguration)) {
            return false;
        }
        TbCreateAlarmNodeConfiguration other = (TbCreateAlarmNodeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        if (this.isPropagate() != other.isPropagate()) {
            return false;
        }
        if (this.isUseMessageAlarmData() != other.isUseMessageAlarmData()) {
            return false;
        }
        List<String> this$relationTypes = this.getRelationTypes();
        List<String> other$relationTypes = other.getRelationTypes();
        return !(this$relationTypes == null ? other$relationTypes != null : !((Object)this$relationTypes).equals(other$relationTypes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbCreateAlarmNodeConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        result = result * 59 + (this.isPropagate() ? 79 : 97);
        result = result * 59 + (this.isUseMessageAlarmData() ? 79 : 97);
        List<String> $relationTypes = this.getRelationTypes();
        result = result * 59 + ($relationTypes == null ? 43 : ((Object)$relationTypes).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TbCreateAlarmNodeConfiguration(severity=" + this.getSeverity() + ", propagate=" + this.isPropagate() + ", useMessageAlarmData=" + this.isUseMessageAlarmData() + ", relationTypes=" + this.getRelationTypes() + ")";
    }
}

