/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbAbstractAlarmNode;
import org.thingsboard.rule.engine.action.TbAlarmResult;
import org.thingsboard.rule.engine.action.TbClearAlarmNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.ACTION, name="clear alarm", relationTypes={"Cleared", "False"}, configClazz=TbClearAlarmNodeConfiguration.class, nodeDescription="Clear Alarm", nodeDetails="Details - JS function that creates JSON object based on incoming message. This object will be added into Alarm.details field.\nNode output:\nIf alarm was not cleared, original message is returned. Otherwise new Message returned with type 'ALARM', Alarm object in 'msg' property and 'metadata' will contains 'isClearedAlarm' property. Message payload can be accessed via <code>msg</code> property. For example <code>'temperature = ' + msg.temperature ;</code>. Message metadata can be accessed via <code>metadata</code> property. For example <code>'name = ' + metadata.customerName;</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeClearAlarmConfig", icon="notifications_off")
public class TbClearAlarmNode
extends TbAbstractAlarmNode<TbClearAlarmNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbClearAlarmNode.class);

    @Override
    protected TbClearAlarmNodeConfiguration loadAlarmNodeConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbClearAlarmNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbClearAlarmNodeConfiguration.class);
    }

    @Override
    protected ListenableFuture<TbAlarmResult> processAlarm(TbContext ctx, TbMsg msg) {
        String alarmType = TbNodeUtils.processPattern((String)((TbClearAlarmNodeConfiguration)this.config).getAlarmType(), (TbMsgMetaData)msg.getMetaData());
        ListenableFuture alarmFuture = msg.getOriginator().getEntityType().equals((Object)EntityType.ALARM) ? ctx.getAlarmService().findAlarmByIdAsync(ctx.getTenantId(), new AlarmId(msg.getOriginator().getId())) : ctx.getAlarmService().findLatestByOriginatorAndType(ctx.getTenantId(), msg.getOriginator(), alarmType);
        return Futures.transformAsync((ListenableFuture)alarmFuture, a -> {
            if (a != null && !a.getStatus().isCleared()) {
                return this.clearAlarm(ctx, msg, (Alarm)a);
            }
            return Futures.immediateFuture((Object)new TbAlarmResult(false, false, false, null));
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<TbAlarmResult> clearAlarm(TbContext ctx, TbMsg msg, Alarm alarm) {
        ctx.logJsEvalRequest();
        ListenableFuture<JsonNode> asyncDetails = this.buildAlarmDetails(ctx, msg, alarm.getDetails());
        return Futures.transformAsync(asyncDetails, details -> {
            ctx.logJsEvalResponse();
            ListenableFuture clearFuture = ctx.getAlarmService().clearAlarm(ctx.getTenantId(), (AlarmId)alarm.getId(), details, System.currentTimeMillis());
            return Futures.transformAsync((ListenableFuture)clearFuture, cleared -> {
                ListenableFuture savedAlarmFuture = ctx.getAlarmService().findAlarmByIdAsync(ctx.getTenantId(), (AlarmId)alarm.getId());
                return Futures.transformAsync((ListenableFuture)savedAlarmFuture, savedAlarm -> {
                    if (cleared.booleanValue() && savedAlarm != null) {
                        alarm.setDetails(savedAlarm.getDetails());
                        alarm.setEndTs(savedAlarm.getEndTs());
                        alarm.setClearTs(savedAlarm.getClearTs());
                    }
                    alarm.setStatus(alarm.getStatus().isAck() ? AlarmStatus.CLEARED_ACK : AlarmStatus.CLEARED_UNACK);
                    return Futures.immediateFuture((Object)new TbAlarmResult(false, false, true, alarm));
                }, (Executor)ctx.getDbCallbackExecutor());
            }, (Executor)ctx.getDbCallbackExecutor());
        }, (Executor)ctx.getDbCallbackExecutor());
    }
}

