/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbAbstractCustomerActionNode;
import org.thingsboard.rule.engine.action.TbAssignToCustomerNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="assign to customer", configClazz=TbAssignToCustomerNodeConfiguration.class, nodeDescription="Assign Message Originator Entity to Customer", nodeDetails="Finds target Customer by customer name pattern and then assign Originator Entity to this customer. Will create new Customer if it doesn't exists and 'Create new Customer if not exists' is set to true.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeAssignToCustomerConfig", icon="add_circle")
public class TbAssignToCustomerNode
extends TbAbstractCustomerActionNode<TbAssignToCustomerNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbAssignToCustomerNode.class);

    @Override
    protected boolean createCustomerIfNotExists() {
        return ((TbAssignToCustomerNodeConfiguration)this.config).isCreateCustomerIfNotExists();
    }

    @Override
    protected TbAssignToCustomerNodeConfiguration loadCustomerNodeActionConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbAssignToCustomerNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbAssignToCustomerNodeConfiguration.class);
    }

    @Override
    protected void doProcessCustomerAction(TbContext ctx, TbMsg msg, CustomerId customerId) {
        this.processAssign(ctx, msg, customerId);
    }

    private void processAssign(TbContext ctx, TbMsg msg, CustomerId customerId) {
        EntityType originatorType = msg.getOriginator().getEntityType();
        switch (originatorType) {
            case DEVICE: {
                this.processAssignDevice(ctx, msg, customerId);
                break;
            }
            case ASSET: {
                this.processAssignAsset(ctx, msg, customerId);
                break;
            }
            case ENTITY_VIEW: {
                this.processAssignEntityView(ctx, msg, customerId);
                break;
            }
            case DASHBOARD: {
                this.processAssignDashboard(ctx, msg, customerId);
                break;
            }
            default: {
                ctx.tellFailure(msg, (Throwable)new RuntimeException("Unsupported originator type '" + originatorType + "'! Only 'DEVICE', 'ASSET',  'ENTITY_VIEW' or 'DASHBOARD' types are allowed."));
            }
        }
    }

    private void processAssignAsset(TbContext ctx, TbMsg msg, CustomerId customerId) {
        ctx.getAssetService().assignAssetToCustomer(ctx.getTenantId(), new AssetId(msg.getOriginator().getId()), customerId);
    }

    private void processAssignDevice(TbContext ctx, TbMsg msg, CustomerId customerId) {
        ctx.getDeviceService().assignDeviceToCustomer(ctx.getTenantId(), new DeviceId(msg.getOriginator().getId()), customerId);
    }

    private void processAssignEntityView(TbContext ctx, TbMsg msg, CustomerId customerId) {
        ctx.getEntityViewService().assignEntityViewToCustomer(ctx.getTenantId(), new EntityViewId(msg.getOriginator().getId()), customerId);
    }

    private void processAssignDashboard(TbContext ctx, TbMsg msg, CustomerId customerId) {
        ctx.getDashboardService().assignDashboardToCustomer(ctx.getTenantId(), new DashboardId(msg.getOriginator().getId()), customerId);
    }
}

