/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractTransformNode;
import org.thingsboard.rule.engine.transform.TbChangeOriginatorNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesAlarmOriginatorIdAsyncLoader;
import org.thingsboard.rule.engine.util.EntitiesCustomerIdAsyncLoader;
import org.thingsboard.rule.engine.util.EntitiesRelatedEntityIdAsyncLoader;
import org.thingsboard.rule.engine.util.EntitiesTenantIdAsyncLoader;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.TRANSFORMATION, name="change originator", configClazz=TbChangeOriginatorNodeConfiguration.class, nodeDescription="Change Message Originator To Tenant/Customer/Related Entity/Alarm Originator", nodeDetails="Related Entity found using configured relation direction and Relation Type. If multiple Related Entities are found, only first Entity is used as new Originator, other entities are discarded.<br/>Alarm Originator found only in case original Originator is <code>Alarm</code> entity.", uiResources={"static/rulenode/rulenode-core-config.js", "static/rulenode/rulenode-core-config.css"}, configDirective="tbTransformationNodeChangeOriginatorConfig", icon="find_replace")
public class TbChangeOriginatorNode
extends TbAbstractTransformNode {
    private static final Logger log = LoggerFactory.getLogger(TbChangeOriginatorNode.class);
    protected static final String CUSTOMER_SOURCE = "CUSTOMER";
    protected static final String TENANT_SOURCE = "TENANT";
    protected static final String RELATED_SOURCE = "RELATED";
    protected static final String ALARM_ORIGINATOR_SOURCE = "ALARM_ORIGINATOR";
    private TbChangeOriginatorNodeConfiguration config;

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbChangeOriginatorNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbChangeOriginatorNodeConfiguration.class);
        this.validateConfig(this.config);
        this.setConfig(this.config);
    }

    @Override
    protected ListenableFuture<TbMsg> transform(TbContext ctx, TbMsg msg) {
        ListenableFuture<? extends EntityId> newOriginator = this.getNewOriginator(ctx, msg.getOriginator());
        return Futures.transform(newOriginator, n -> {
            if (n == null || n.isNullUid()) {
                return null;
            }
            return ctx.transformMsg(msg, msg.getType(), n, msg.getMetaData(), msg.getData());
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<? extends EntityId> getNewOriginator(TbContext ctx, EntityId original) {
        switch (this.config.getOriginatorSource()) {
            case "CUSTOMER": {
                return EntitiesCustomerIdAsyncLoader.findEntityIdAsync(ctx, original);
            }
            case "TENANT": {
                return EntitiesTenantIdAsyncLoader.findEntityIdAsync(ctx, original);
            }
            case "RELATED": {
                return EntitiesRelatedEntityIdAsyncLoader.findEntityAsync(ctx, original, this.config.getRelationsQuery());
            }
            case "ALARM_ORIGINATOR": {
                return EntitiesAlarmOriginatorIdAsyncLoader.findEntityIdAsync(ctx, original);
            }
        }
        return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Unexpected originator source " + this.config.getOriginatorSource()));
    }

    private void validateConfig(TbChangeOriginatorNodeConfiguration conf) {
        HashSet knownSources = Sets.newHashSet((Object[])new String[]{CUSTOMER_SOURCE, TENANT_SOURCE, RELATED_SOURCE, ALARM_ORIGINATOR_SOURCE});
        if (!knownSources.contains(conf.getOriginatorSource())) {
            log.error("Unsupported source [{}] for TbChangeOriginatorNode", (Object)conf.getOriginatorSource());
            throw new IllegalArgumentException("Unsupported source TbChangeOriginatorNode" + conf.getOriginatorSource());
        }
        if (conf.getOriginatorSource().equals(RELATED_SOURCE) && conf.getRelationsQuery() == null) {
            log.error("Related source for TbChangeOriginatorNode should have relations query. Actual [{}]", (Object)conf.getRelationsQuery());
            throw new IllegalArgumentException("Wrong config for RElated Source in TbChangeOriginatorNode" + conf.getOriginatorSource());
        }
    }

    public void destroy() {
    }
}

