/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbTransformNodeConfiguration;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class TbAbstractTransformNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractTransformNode.class);
    private TbTransformNodeConfiguration config;

    public void init(TbContext context, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbTransformNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbTransformNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        DonAsynchron.withCallback(this.transform(ctx, msg), m -> this.transformSuccess(ctx, msg, (TbMsg)m), t -> this.transformFailure(ctx, msg, (Throwable)t), (Executor)ctx.getDbCallbackExecutor());
    }

    protected void transformFailure(TbContext ctx, TbMsg msg, Throwable t) {
        ctx.tellFailure(msg, t);
    }

    protected void transformSuccess(TbContext ctx, TbMsg msg, TbMsg m) {
        if (m != null) {
            ctx.tellSuccess(m);
        } else {
            ctx.tellNext(msg, TbRelationTypes.FAILURE);
        }
    }

    protected abstract ListenableFuture<TbMsg> transform(TbContext var1, TbMsg var2);

    public void setConfig(TbTransformNodeConfiguration config) {
        this.config = config;
    }
}

