/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.server.common.msg.TbMsg;

class TelemetryNodeCallback
implements FutureCallback<Void> {
    private final TbContext ctx;
    private final TbMsg msg;

    public void onSuccess(@Nullable Void result) {
        this.ctx.tellSuccess(this.msg);
    }

    public void onFailure(Throwable t) {
        this.ctx.tellFailure(this.msg, t);
    }

    @ConstructorProperties(value={"ctx", "msg"})
    public TelemetryNodeCallback(TbContext ctx, TbMsg msg) {
        this.ctx = ctx;
        this.msg = msg;
    }

    public TbContext getCtx() {
        return this.ctx;
    }

    public TbMsg getMsg() {
        return this.msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelemetryNodeCallback)) {
            return false;
        }
        TelemetryNodeCallback other = (TelemetryNodeCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TbContext this$ctx = this.getCtx();
        TbContext other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        TbMsg this$msg = this.getMsg();
        TbMsg other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TelemetryNodeCallback;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TbContext $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        TbMsg $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "TelemetryNodeCallback(ctx=" + this.getCtx() + ", msg=" + this.getMsg() + ")";
    }
}

