/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.telemetry.TbMsgAttributesNodeConfiguration;
import org.thingsboard.rule.engine.telemetry.TelemetryNodeCallback;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.session.SessionMsgType;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;

@RuleNode(type=ComponentType.ACTION, name="save attributes", configClazz=TbMsgAttributesNodeConfiguration.class, nodeDescription="Saves attributes data", nodeDetails="Saves entity attributes based on configurable scope parameter. Expects messages with 'POST_ATTRIBUTES_REQUEST' message type", uiResources={"static/rulenode/rulenode-core-config.js", "static/rulenode/rulenode-core-config.css"}, configDirective="tbActionNodeAttributesConfig", icon="file_upload")
public class TbMsgAttributesNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgAttributesNode.class);
    private TbMsgAttributesNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgAttributesNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgAttributesNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        if (!msg.getType().equals(SessionMsgType.POST_ATTRIBUTES_REQUEST.name())) {
            ctx.tellFailure(msg, (Throwable)new IllegalArgumentException("Unsupported msg type: " + msg.getType()));
            return;
        }
        String src = msg.getData();
        Set attributes = JsonConverter.convertToAttributes((JsonElement)new JsonParser().parse(src));
        ctx.getTelemetryService().saveAndNotify(ctx.getTenantId(), msg.getOriginator(), this.config.getScope(), new ArrayList(attributes), (FutureCallback)new TelemetryNodeCallback(ctx, msg));
    }

    public void destroy() {
    }
}

