/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mqtt.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.ByteArrayInputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.rule.engine.mqtt.credentials.MqttClientCredentials;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CertPemClientCredentials
implements MqttClientCredentials {
    private static final Logger log = LoggerFactory.getLogger(CertPemClientCredentials.class);
    private static final String TLS_VERSION = "TLSv1.2";
    private String caCert;
    private String cert;
    private String privateKey;
    private String password;

    @Override
    public Optional<SslContext> initSslContext() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            return Optional.of(SslContextBuilder.forClient().keyManager(this.createAndInitKeyManagerFactory()).trustManager(this.createAndInitTrustManagerFactory()).clientAuth(ClientAuth.REQUIRE).build());
        }
        catch (Exception e) {
            log.error("[{}:{}] Creating TLS factory failed!", new Object[]{this.caCert, this.cert, e});
            throw new RuntimeException("Creating TLS factory failed!", e);
        }
    }

    @Override
    public void configure(MqttClientConfig config) {
    }

    private KeyManagerFactory createAndInitKeyManagerFactory() throws Exception {
        PrivateKey privateKey;
        X509Certificate certHolder = this.readCertFile(this.cert);
        PrivateKey keyObject = this.readPrivateKeyFile(this.privateKey);
        char[] passwordCharArray = "".toCharArray();
        if (!StringUtils.isEmpty((Object)this.password)) {
            passwordCharArray = this.password.toCharArray();
        }
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
        if (keyObject instanceof PEMEncryptedKeyPair) {
            PEMDecryptorProvider provider = new JcePEMDecryptorProviderBuilder().build(passwordCharArray);
            KeyPair key = keyConverter.getKeyPair(((PEMEncryptedKeyPair)keyObject).decryptKeyPair(provider));
            privateKey = key.getPrivate();
        } else if (keyObject instanceof PEMKeyPair) {
            KeyPair key = keyConverter.getKeyPair((PEMKeyPair)keyObject);
            privateKey = key.getPrivate();
        } else if (keyObject instanceof PrivateKey) {
            privateKey = keyObject;
        } else {
            throw new RuntimeException("Unable to get private key from object: " + keyObject.getClass());
        }
        KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        clientKeyStore.load(null, null);
        clientKeyStore.setCertificateEntry("cert", certHolder);
        clientKeyStore.setKeyEntry("private-key", privateKey, passwordCharArray, new Certificate[]{certHolder});
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(clientKeyStore, passwordCharArray);
        return keyManagerFactory;
    }

    private TrustManagerFactory createAndInitTrustManagerFactory() throws Exception {
        X509Certificate caCertHolder = this.readCertFile(this.caCert);
        KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        caKeyStore.load(null, null);
        caKeyStore.setCertificateEntry("caCert-cert", caCertHolder);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(caKeyStore);
        return trustManagerFactory;
    }

    private X509Certificate readCertFile(String fileContent) throws Exception {
        X509Certificate certificate = null;
        if (fileContent != null && !fileContent.trim().isEmpty()) {
            fileContent = fileContent.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\\s", "");
            byte[] decoded = Base64.decodeBase64((String)fileContent);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(decoded));
        }
        return certificate;
    }

    private PrivateKey readPrivateKeyFile(String fileContent) throws Exception {
        PrivateKey privateKey = null;
        if (fileContent != null && !fileContent.isEmpty()) {
            fileContent = fileContent.replaceAll(".*BEGIN.*PRIVATE KEY.*", "").replaceAll(".*END.*PRIVATE KEY.*", "").replaceAll("\\s", "");
            byte[] decoded = Base64.decodeBase64((String)fileContent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            KeySpec keySpec = this.getKeySpec(decoded);
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        return privateKey;
    }

    private KeySpec getKeySpec(byte[] encodedKey) throws Exception {
        PKCS8EncodedKeySpec keySpec;
        if (this.password == null || this.password.isEmpty()) {
            keySpec = new PKCS8EncodedKeySpec(encodedKey);
        } else {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password.toCharArray());
            EncryptedPrivateKeyInfo privateKeyInfo = new EncryptedPrivateKeyInfo(encodedKey);
            String algorithmName = privateKeyInfo.getAlgName();
            Cipher cipher = Cipher.getInstance(algorithmName);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithmName);
            SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
            AlgorithmParameters algParams = privateKeyInfo.getAlgParameters();
            cipher.init(2, (Key)pbeKey, algParams);
            keySpec = privateKeyInfo.getKeySpec(cipher);
        }
        return keySpec;
    }

    public String getCaCert() {
        return this.caCert;
    }

    public String getCert() {
        return this.cert;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPassword() {
        return this.password;
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertPemClientCredentials)) {
            return false;
        }
        CertPemClientCredentials other = (CertPemClientCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$caCert = this.getCaCert();
        String other$caCert = other.getCaCert();
        if (this$caCert == null ? other$caCert != null : !this$caCert.equals(other$caCert)) {
            return false;
        }
        String this$cert = this.getCert();
        String other$cert = other.getCert();
        if (this$cert == null ? other$cert != null : !this$cert.equals(other$cert)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CertPemClientCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $caCert = this.getCaCert();
        result = result * 59 + ($caCert == null ? 43 : $caCert.hashCode());
        String $cert = this.getCert();
        result = result * 59 + ($cert == null ? 43 : $cert.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "CertPemClientCredentials(caCert=" + this.getCaCert() + ", cert=" + this.getCert() + ", privateKey=" + this.getPrivateKey() + ", password=" + this.getPassword() + ")";
    }
}

