/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mqtt.azure;

import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.handler.ssl.SslContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.AzureIotHubUtil;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.mqtt.TbMqttNode;
import org.thingsboard.rule.engine.mqtt.TbMqttNodeConfiguration;
import org.thingsboard.rule.engine.mqtt.azure.AzureIotHubSasCredentials;
import org.thingsboard.rule.engine.mqtt.azure.TbAzureIotHubNodeConfiguration;
import org.thingsboard.rule.engine.mqtt.credentials.CertPemClientCredentials;
import org.thingsboard.rule.engine.mqtt.credentials.MqttClientCredentials;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.EXTERNAL, name="azure iot hub", configClazz=TbAzureIotHubNodeConfiguration.class, nodeDescription="Publish messages to the Azure IoT Hub", nodeDetails="Will publish message payload to the Azure IoT Hub with QoS <b>AT_LEAST_ONCE</b>.", uiResources={"static/rulenode/rulenode-core-config.js", "static/rulenode/rulenode-core-config.css"}, configDirective="tbActionNodeAzureIotHubConfig")
public class TbAzureIotHubNode
extends TbMqttNode {
    private static final Logger log = LoggerFactory.getLogger(TbAzureIotHubNode.class);

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        try {
            this.mqttNodeConfiguration = (TbMqttNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMqttNodeConfiguration.class);
            this.mqttNodeConfiguration.setPort(8883);
            this.mqttNodeConfiguration.setCleanSession(true);
            final MqttClientCredentials credentials = this.mqttNodeConfiguration.getCredentials();
            this.mqttNodeConfiguration.setCredentials(new MqttClientCredentials(){

                @Override
                public Optional<SslContext> initSslContext() {
                    CertPemClientCredentials pemCredentials;
                    if (credentials instanceof AzureIotHubSasCredentials) {
                        AzureIotHubSasCredentials sasCredentials = (AzureIotHubSasCredentials)credentials;
                        if (sasCredentials.getCaCert() == null || sasCredentials.getCaCert().isEmpty()) {
                            sasCredentials.setCaCert(AzureIotHubUtil.getDefaultCaCert());
                        }
                    } else if (credentials instanceof CertPemClientCredentials && ((pemCredentials = (CertPemClientCredentials)credentials).getCaCert() == null || pemCredentials.getCaCert().isEmpty())) {
                        pemCredentials.setCaCert(AzureIotHubUtil.getDefaultCaCert());
                    }
                    return credentials.initSslContext();
                }

                @Override
                public void configure(MqttClientConfig config) {
                    config.setProtocolVersion(MqttVersion.MQTT_3_1_1);
                    config.setUsername(AzureIotHubUtil.buildUsername((String)TbAzureIotHubNode.this.mqttNodeConfiguration.getHost(), (String)config.getClientId()));
                    if (credentials instanceof AzureIotHubSasCredentials) {
                        AzureIotHubSasCredentials sasCredentials = (AzureIotHubSasCredentials)credentials;
                        config.setPassword(AzureIotHubUtil.buildSasToken((String)TbAzureIotHubNode.this.mqttNodeConfiguration.getHost(), (String)sasCredentials.getSasKey()));
                    }
                }
            });
            this.mqttClient = this.initClient(ctx);
        }
        catch (Exception e) {
            throw new TbNodeException(e);
        }
    }
}

