/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mqtt.azure;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.AzureIotHubUtil;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.rule.engine.mqtt.credentials.MqttClientCredentials;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AzureIotHubSasCredentials
implements MqttClientCredentials {
    private static final Logger log = LoggerFactory.getLogger(AzureIotHubSasCredentials.class);
    private String sasKey;
    private String caCert;

    @Override
    public Optional<SslContext> initSslContext() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (this.caCert == null || this.caCert.isEmpty()) {
                this.caCert = AzureIotHubUtil.getDefaultCaCert();
            }
            return Optional.of(SslContextBuilder.forClient().trustManager(this.createAndInitTrustManagerFactory()).clientAuth(ClientAuth.REQUIRE).build());
        }
        catch (Exception e) {
            log.error("[{}] Creating TLS factory failed!", (Object)this.caCert, (Object)e);
            throw new RuntimeException("Creating TLS factory failed!", e);
        }
    }

    @Override
    public void configure(MqttClientConfig config) {
    }

    private TrustManagerFactory createAndInitTrustManagerFactory() throws Exception {
        X509Certificate caCertHolder = this.readCertFile(this.caCert);
        KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        caKeyStore.load(null, null);
        caKeyStore.setCertificateEntry("caCert-cert", caCertHolder);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(caKeyStore);
        return trustManagerFactory;
    }

    private X509Certificate readCertFile(String fileContent) throws Exception {
        X509Certificate certificate = null;
        if (fileContent != null && !fileContent.trim().isEmpty()) {
            fileContent = fileContent.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\\s", "");
            byte[] decoded = Base64.decodeBase64((String)fileContent);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(decoded));
        }
        return certificate;
    }

    public String getSasKey() {
        return this.sasKey;
    }

    public String getCaCert() {
        return this.caCert;
    }

    public void setSasKey(String sasKey) {
        this.sasKey = sasKey;
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureIotHubSasCredentials)) {
            return false;
        }
        AzureIotHubSasCredentials other = (AzureIotHubSasCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sasKey = this.getSasKey();
        String other$sasKey = other.getSasKey();
        if (this$sasKey == null ? other$sasKey != null : !this$sasKey.equals(other$sasKey)) {
            return false;
        }
        String this$caCert = this.getCaCert();
        String other$caCert = other.getCaCert();
        return !(this$caCert == null ? other$caCert != null : !this$caCert.equals(other$caCert));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AzureIotHubSasCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sasKey = this.getSasKey();
        result = result * 59 + ($sasKey == null ? 43 : $sasKey.hashCode());
        String $caCert = this.getCaCert();
        result = result * 59 + ($caCert == null ? 43 : $caCert.hashCode());
        return result;
    }

    public String toString() {
        return "AzureIotHubSasCredentials(sasKey=" + this.getSasKey() + ", caCert=" + this.getCaCert() + ")";
    }
}

