/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbGetTelemetryNodeConfiguration;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.ENRICHMENT, name="originator telemetry", configClazz=TbGetTelemetryNodeConfiguration.class, nodeDescription="Add Message Originator Telemetry for selected time range into Message Metadata\n", nodeDetails="The node allows you to select fetch mode: <b>FIRST/LAST/ALL</b> to fetch telemetry of certain time range that are added into Message metadata without any prefix. If selected fetch mode <b>ALL</b> Telemetry will be added like array into Message Metadata where <b>key</b> is Timestamp and <b>value</b> is value of Telemetry.</br>If selected fetch mode <b>FIRST</b> or <b>LAST</b> Telemetry will be added like string without Timestamp.</br>Also, the rule node allows you to select telemetry sampling order: <b>ASC</b> or <b>DESC</b>. </br><b>Note</b>: The maximum size of the fetched array is 1000 records.\n ", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeGetTelemetryFromDatabase")
public class TbGetTelemetryNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbGetTelemetryNode.class);
    private static final String DESC_ORDER = "DESC";
    private static final String ASC_ORDER = "ASC";
    private TbGetTelemetryNodeConfiguration config;
    private List<String> tsKeyNames;
    private int limit;
    private ObjectMapper mapper;
    private String fetchMode;
    private String orderByFetchAll;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbGetTelemetryNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetTelemetryNodeConfiguration.class);
        this.tsKeyNames = this.config.getLatestTsKeyNames();
        this.limit = this.config.getFetchMode().equals("ALL") ? this.validateLimit(this.config.getLimit()) : 1;
        this.fetchMode = this.config.getFetchMode();
        this.orderByFetchAll = this.config.getOrderBy();
        if (StringUtils.isEmpty((CharSequence)this.orderByFetchAll)) {
            this.orderByFetchAll = ASC_ORDER;
        }
        this.mapper = new ObjectMapper();
        this.mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        if (this.tsKeyNames.isEmpty()) {
            ctx.tellFailure(msg, (Throwable)new IllegalStateException("Telemetry is not selected!"));
        } else {
            try {
                if (this.config.isUseMetadataIntervalPatterns()) {
                    this.checkMetadataKeyPatterns(msg);
                }
                List keys = TbNodeUtils.processPatterns(this.tsKeyNames, (TbMsgMetaData)msg.getMetaData());
                ListenableFuture list = ctx.getTimeseriesService().findAll(ctx.getTenantId(), msg.getOriginator(), this.buildQueries(msg, keys));
                DonAsynchron.withCallback((ListenableFuture)list, data -> {
                    this.process((List<TsKvEntry>)data, msg, keys);
                    ctx.tellSuccess(ctx.transformMsg(msg, msg.getType(), msg.getOriginator(), msg.getMetaData(), msg.getData()));
                }, error -> ctx.tellFailure(msg, error), (Executor)ctx.getDbCallbackExecutor());
            }
            catch (Exception e) {
                ctx.tellFailure(msg, (Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    private List<ReadTsKvQuery> buildQueries(TbMsg msg, List<String> keys) {
        return keys.stream().map(key -> new BaseReadTsKvQuery(key, this.getInterval(msg).getStartTs().longValue(), this.getInterval(msg).getEndTs().longValue(), 1L, this.limit, Aggregation.NONE, this.getOrderBy())).collect(Collectors.toList());
    }

    private String getOrderBy() {
        switch (this.fetchMode) {
            case "ALL": {
                return this.orderByFetchAll;
            }
            case "FIRST": {
                return ASC_ORDER;
            }
        }
        return DESC_ORDER;
    }

    private void process(List<TsKvEntry> entries, TbMsg msg, List<String> keys) {
        ObjectNode resultNode = this.mapper.createObjectNode();
        if ("ALL".equals(this.fetchMode)) {
            entries.forEach(entry -> this.processArray(resultNode, (TsKvEntry)entry));
        } else {
            entries.forEach(entry -> this.processSingle(resultNode, (TsKvEntry)entry));
        }
        for (String key : keys) {
            if (!resultNode.has(key)) continue;
            msg.getMetaData().putValue(key, resultNode.get(key).toString());
        }
    }

    private void processSingle(ObjectNode node, TsKvEntry entry) {
        node.put(entry.getKey(), entry.getValueAsString());
    }

    private void processArray(ObjectNode node, TsKvEntry entry) {
        if (node.has(entry.getKey())) {
            ArrayNode arrayNode = (ArrayNode)node.get(entry.getKey());
            arrayNode.add((JsonNode)this.buildNode(entry));
        } else {
            ArrayNode arrayNode = this.mapper.createArrayNode();
            arrayNode.add((JsonNode)this.buildNode(entry));
            node.set(entry.getKey(), (JsonNode)arrayNode);
        }
    }

    private ObjectNode buildNode(TsKvEntry entry) {
        ObjectNode obj = this.mapper.createObjectNode().put("ts", entry.getTs());
        switch (entry.getDataType()) {
            case STRING: {
                obj.put("value", entry.getValueAsString());
                break;
            }
            case LONG: {
                obj.put("value", (Long)entry.getLongValue().get());
                break;
            }
            case BOOLEAN: {
                obj.put("value", (Boolean)entry.getBooleanValue().get());
                break;
            }
            case DOUBLE: {
                obj.put("value", (Double)entry.getDoubleValue().get());
                break;
            }
            case JSON: {
                try {
                    obj.set("value", this.mapper.readTree((String)entry.getJsonValue().get()));
                    break;
                }
                catch (IOException e) {
                    throw new JsonParseException("Can't parse jsonValue: " + (String)entry.getJsonValue().get(), (Throwable)e);
                }
            }
        }
        return obj;
    }

    private Interval getInterval(TbMsg msg) {
        Interval interval = new Interval();
        if (this.config.isUseMetadataIntervalPatterns()) {
            if (this.isParsable(msg, this.config.getStartIntervalPattern())) {
                interval.setStartTs(Long.parseLong(TbNodeUtils.processPattern((String)this.config.getStartIntervalPattern(), (TbMsgMetaData)msg.getMetaData())));
            }
            if (this.isParsable(msg, this.config.getEndIntervalPattern())) {
                interval.setEndTs(Long.parseLong(TbNodeUtils.processPattern((String)this.config.getEndIntervalPattern(), (TbMsgMetaData)msg.getMetaData())));
            }
        } else {
            long ts = System.currentTimeMillis();
            interval.setStartTs(ts - TimeUnit.valueOf(this.config.getStartIntervalTimeUnit()).toMillis(this.config.getStartInterval()));
            interval.setEndTs(ts - TimeUnit.valueOf(this.config.getEndIntervalTimeUnit()).toMillis(this.config.getEndInterval()));
        }
        return interval;
    }

    private boolean isParsable(TbMsg msg, String pattern) {
        return NumberUtils.isParsable((String)TbNodeUtils.processPattern((String)pattern, (TbMsgMetaData)msg.getMetaData()));
    }

    private void checkMetadataKeyPatterns(TbMsg msg) {
        this.isUndefined(msg, this.config.getStartIntervalPattern(), this.config.getEndIntervalPattern());
        this.isInvalid(msg, this.config.getStartIntervalPattern(), this.config.getEndIntervalPattern());
    }

    private void isUndefined(TbMsg msg, String startIntervalPattern, String endIntervalPattern) {
        if (this.getMetadataValue(msg, startIntervalPattern) == null && this.getMetadataValue(msg, endIntervalPattern) == null) {
            throw new IllegalArgumentException("Message metadata values: '" + this.replaceRegex(startIntervalPattern) + "' and '" + this.replaceRegex(endIntervalPattern) + "' are undefined");
        }
        if (this.getMetadataValue(msg, startIntervalPattern) == null) {
            throw new IllegalArgumentException("Message metadata value: '" + this.replaceRegex(startIntervalPattern) + "' is undefined");
        }
        if (this.getMetadataValue(msg, endIntervalPattern) == null) {
            throw new IllegalArgumentException("Message metadata value: '" + this.replaceRegex(endIntervalPattern) + "' is undefined");
        }
    }

    private void isInvalid(TbMsg msg, String startIntervalPattern, String endIntervalPattern) {
        if (this.getInterval(msg).getStartTs() == null && this.getInterval(msg).getEndTs() == null) {
            throw new IllegalArgumentException("Message metadata values: '" + this.replaceRegex(startIntervalPattern) + "' and '" + this.replaceRegex(endIntervalPattern) + "' have invalid format");
        }
        if (this.getInterval(msg).getStartTs() == null) {
            throw new IllegalArgumentException("Message metadata value: '" + this.replaceRegex(startIntervalPattern) + "' has invalid format");
        }
        if (this.getInterval(msg).getEndTs() == null) {
            throw new IllegalArgumentException("Message metadata value: '" + this.replaceRegex(endIntervalPattern) + "' has invalid format");
        }
    }

    private String getMetadataValue(TbMsg msg, String pattern) {
        return msg.getMetaData().getValue(this.replaceRegex(pattern));
    }

    private String replaceRegex(String pattern) {
        return pattern.replaceAll("[${}]", "");
    }

    private int validateLimit(int limit) {
        if (limit != 0) {
            return limit;
        }
        return 1000;
    }

    private static class Interval {
        private Long startTs;
        private Long endTs;

        public Long getStartTs() {
            return this.startTs;
        }

        public Long getEndTs() {
            return this.endTs;
        }

        public void setStartTs(Long startTs) {
            this.startTs = startTs;
        }

        public void setEndTs(Long endTs) {
            this.endTs = endTs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Interval)) {
                return false;
            }
            Interval other = (Interval)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$startTs = this.getStartTs();
            Long other$startTs = other.getStartTs();
            if (this$startTs == null ? other$startTs != null : !((Object)this$startTs).equals(other$startTs)) {
                return false;
            }
            Long this$endTs = this.getEndTs();
            Long other$endTs = other.getEndTs();
            return !(this$endTs == null ? other$endTs != null : !((Object)this$endTs).equals(other$endTs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Interval;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $startTs = this.getStartTs();
            result = result * 59 + ($startTs == null ? 43 : ((Object)$startTs).hashCode());
            Long $endTs = this.getEndTs();
            result = result * 59 + ($endTs == null ? 43 : ((Object)$endTs).hashCode());
            return result;
        }

        public String toString() {
            return "TbGetTelemetryNode.Interval(startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ")";
        }
    }
}

