/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbGetAttributesNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public abstract class TbAbstractGetAttributesNode<C extends TbGetAttributesNodeConfiguration, T extends EntityId>
implements TbNode {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final String VALUE = "value";
    private static final String TS = "ts";
    protected C config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = this.loadGetAttributesNodeConfig(configuration);
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    protected abstract C loadGetAttributesNodeConfig(TbNodeConfiguration var1) throws TbNodeException;

    public void onMsg(TbContext ctx, TbMsg msg) throws TbNodeException {
        try {
            DonAsynchron.withCallback(this.findEntityIdAsync(ctx, msg), entityId -> this.safePutAttributes(ctx, msg, entityId), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
        }
        catch (Throwable th) {
            ctx.tellFailure(msg, th);
        }
    }

    public void destroy() {
    }

    protected abstract ListenableFuture<T> findEntityIdAsync(TbContext var1, TbMsg var2);

    private void safePutAttributes(TbContext ctx, TbMsg msg, T entityId) {
        if (entityId == null || entityId.isNullUid()) {
            ctx.tellNext(msg, TbRelationTypes.FAILURE);
            return;
        }
        ConcurrentHashMap<String, List<String>> failuresMap = new ConcurrentHashMap<String, List<String>>();
        ListenableFuture allFutures = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.putLatestTelemetry(ctx, (EntityId)entityId, msg, "LATEST_TS", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getLatestTsKeyNames(), (TbMsgMetaData)msg.getMetaData()), failuresMap), this.putAttrAsync(ctx, (EntityId)entityId, msg, "CLIENT_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getClientAttributeNames(), (TbMsgMetaData)msg.getMetaData()), failuresMap, "cs_"), this.putAttrAsync(ctx, (EntityId)entityId, msg, "SHARED_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getSharedAttributeNames(), (TbMsgMetaData)msg.getMetaData()), failuresMap, "shared_"), this.putAttrAsync(ctx, (EntityId)entityId, msg, "SERVER_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getServerAttributeNames(), (TbMsgMetaData)msg.getMetaData()), failuresMap, "ss_")});
        DonAsynchron.withCallback((ListenableFuture)allFutures, i -> {
            if (!failuresMap.isEmpty()) {
                throw this.reportFailures(failuresMap);
            }
            ctx.tellSuccess(msg);
        }, t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Void> putAttrAsync(TbContext ctx, EntityId entityId, TbMsg msg, String scope, List<String> keys, ConcurrentHashMap<String, List<String>> failuresMap, String prefix) {
        if (CollectionUtils.isEmpty(keys)) {
            return Futures.immediateFuture(null);
        }
        ListenableFuture attributeKvEntryListFuture = ctx.getAttributesService().find(ctx.getTenantId(), entityId, scope, keys);
        return Futures.transform((ListenableFuture)attributeKvEntryListFuture, attributeKvEntryList -> {
            if (!CollectionUtils.isEmpty((Collection)attributeKvEntryList)) {
                List<AttributeKvEntry> existingAttributesKvEntry = attributeKvEntryList.stream().filter(attributeKvEntry -> keys.contains(attributeKvEntry.getKey())).collect(Collectors.toList());
                existingAttributesKvEntry.forEach(kvEntry -> msg.getMetaData().putValue(prefix + kvEntry.getKey(), kvEntry.getValueAsString()));
                if (existingAttributesKvEntry.size() != keys.size() && BooleanUtils.toBooleanDefaultIfNull((Boolean)((TbGetAttributesNodeConfiguration)this.config).isTellFailureIfAbsent(), (boolean)true)) {
                    this.getNotExistingKeys(existingAttributesKvEntry, keys).forEach(key -> this.computeFailuresMap(scope, failuresMap, (String)key));
                }
            } else if (BooleanUtils.toBooleanDefaultIfNull((Boolean)((TbGetAttributesNodeConfiguration)this.config).isTellFailureIfAbsent(), (boolean)true)) {
                keys.forEach(key -> this.computeFailuresMap(scope, failuresMap, (String)key));
            }
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Void> putLatestTelemetry(TbContext ctx, EntityId entityId, TbMsg msg, String scope, List<String> keys, ConcurrentHashMap<String, List<String>> failuresMap) {
        if (CollectionUtils.isEmpty(keys)) {
            return Futures.immediateFuture(null);
        }
        ListenableFuture latest = ctx.getTimeseriesService().findLatest(ctx.getTenantId(), entityId, keys);
        return Futures.transform((ListenableFuture)latest, l -> {
            l.forEach(r -> {
                boolean getLatestValueWithTs = BooleanUtils.toBooleanDefaultIfNull((Boolean)((TbGetAttributesNodeConfiguration)this.config).isGetLatestValueWithTs(), (boolean)false);
                if (BooleanUtils.toBooleanDefaultIfNull((Boolean)((TbGetAttributesNodeConfiguration)this.config).isTellFailureIfAbsent(), (boolean)true)) {
                    if (r.getValue() == null) {
                        this.computeFailuresMap(scope, failuresMap, r.getKey());
                    } else if (getLatestValueWithTs) {
                        this.putValueWithTs(msg, (TsKvEntry)r);
                    } else {
                        msg.getMetaData().putValue(r.getKey(), r.getValueAsString());
                    }
                } else if (r.getValue() != null) {
                    if (getLatestValueWithTs) {
                        this.putValueWithTs(msg, (TsKvEntry)r);
                    } else {
                        msg.getMetaData().putValue(r.getKey(), r.getValueAsString());
                    }
                }
            });
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void putValueWithTs(TbMsg msg, TsKvEntry r) {
        ObjectNode value = mapper.createObjectNode();
        value.put(TS, r.getTs());
        switch (r.getDataType()) {
            case STRING: {
                value.put(VALUE, r.getValueAsString());
                break;
            }
            case LONG: {
                value.put(VALUE, (Long)r.getLongValue().get());
                break;
            }
            case BOOLEAN: {
                value.put(VALUE, (Boolean)r.getBooleanValue().get());
                break;
            }
            case DOUBLE: {
                value.put(VALUE, (Double)r.getDoubleValue().get());
                break;
            }
            case JSON: {
                try {
                    value.set(VALUE, mapper.readTree((String)r.getJsonValue().get()));
                    break;
                }
                catch (IOException e) {
                    throw new JsonParseException("Can't parse jsonValue: " + (String)r.getJsonValue().get(), (Throwable)e);
                }
            }
        }
        msg.getMetaData().putValue(r.getKey(), value.toString());
    }

    private List<String> getNotExistingKeys(List<AttributeKvEntry> existingAttributesKvEntry, List<String> allKeys) {
        List existingKeys = existingAttributesKvEntry.stream().map(KvEntry::getKey).collect(Collectors.toList());
        return allKeys.stream().filter(key -> !existingKeys.contains(key)).collect(Collectors.toList());
    }

    private void computeFailuresMap(String scope, ConcurrentHashMap<String, List<String>> failuresMap, String key) {
        List failures = failuresMap.computeIfAbsent(scope, k -> new ArrayList());
        failures.add(key);
    }

    private RuntimeException reportFailures(ConcurrentHashMap<String, List<String>> failuresMap) {
        StringBuilder errorMessage = new StringBuilder("The following attribute/telemetry keys is not present in the DB: ").append("\n");
        if (failuresMap.containsKey("CLIENT_SCOPE")) {
            errorMessage.append("\t").append("[CLIENT_SCOPE]:").append(failuresMap.get("CLIENT_SCOPE").toString()).append("\n");
        }
        if (failuresMap.containsKey("SERVER_SCOPE")) {
            errorMessage.append("\t").append("[SERVER_SCOPE]:").append(failuresMap.get("SERVER_SCOPE").toString()).append("\n");
        }
        if (failuresMap.containsKey("SHARED_SCOPE")) {
            errorMessage.append("\t").append("[SHARED_SCOPE]:").append(failuresMap.get("SHARED_SCOPE").toString()).append("\n");
        }
        if (failuresMap.containsKey("LATEST_TS")) {
            errorMessage.append("\t").append("[LATEST_TS]:").append(failuresMap.get("LATEST_TS").toString()).append("\n");
        }
        failuresMap.clear();
        return new RuntimeException(errorMessage.toString());
    }
}

