/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mail;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.mail.EmailPojo;
import org.thingsboard.rule.engine.mail.TbMsgToEmailNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.TRANSFORMATION, name="to email", configClazz=TbMsgToEmailNodeConfiguration.class, nodeDescription="Transforms message to email message", nodeDetails="Transforms message to email message by populating email fields using values derived from message metadata. Set 'SEND_EMAIL' output message type.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeToEmailConfig", icon="email")
public class TbMsgToEmailNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgToEmailNode.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private TbMsgToEmailNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgToEmailNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgToEmailNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            EmailPojo email = this.convert(msg);
            TbMsg emailMsg = this.buildEmailMsg(ctx, msg, email);
            ctx.tellNext(emailMsg, TbRelationTypes.SUCCESS);
        }
        catch (Exception ex) {
            log.warn("Can not convert message to email " + ex.getMessage());
            ctx.tellFailure(msg, (Throwable)ex);
        }
    }

    private TbMsg buildEmailMsg(TbContext ctx, TbMsg msg, EmailPojo email) throws JsonProcessingException {
        String emailJson = MAPPER.writeValueAsString((Object)email);
        return ctx.transformMsg(msg, "SEND_EMAIL", msg.getOriginator(), msg.getMetaData().copy(), emailJson);
    }

    private EmailPojo convert(TbMsg msg) throws IOException {
        EmailPojo.EmailPojoBuilder builder = EmailPojo.builder();
        builder.from(this.fromTemplate(this.config.getFromTemplate(), msg.getMetaData()));
        builder.to(this.fromTemplate(this.config.getToTemplate(), msg.getMetaData()));
        builder.cc(this.fromTemplate(this.config.getCcTemplate(), msg.getMetaData()));
        builder.bcc(this.fromTemplate(this.config.getBccTemplate(), msg.getMetaData()));
        builder.subject(this.fromTemplate(this.config.getSubjectTemplate(), msg.getMetaData()));
        builder.body(this.fromTemplate(this.config.getBodyTemplate(), msg.getMetaData()));
        return builder.build();
    }

    private String fromTemplate(String template, TbMsgMetaData metaData) {
        if (!StringUtils.isEmpty((Object)template)) {
            return TbNodeUtils.processPattern((String)template, (TbMsgMetaData)metaData);
        }
        return null;
    }

    public void destroy() {
    }
}

