/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.flow.TbCheckpointNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="checkpoint", configClazz=TbCheckpointNodeConfiguration.class, nodeDescription="transfers the message to another queue", nodeDetails="After successful transfer incoming message is automatically acknowledged. Queue name is configurable.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeCheckPointConfig")
public class TbCheckpointNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCheckpointNode.class);
    private TbCheckpointNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbCheckpointNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCheckpointNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        ctx.enqueueForTellNext(msg, this.config.getQueueName(), TbRelationTypes.SUCCESS, () -> ctx.ack(msg), error -> ctx.tellFailure(msg, error));
    }

    public void destroy() {
    }
}

