/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbMsgTypeFilterNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="message type", configClazz=TbMsgTypeFilterNodeConfiguration.class, relationTypes={"True", "False"}, nodeDescription="Filter incoming messages by Message Type", nodeDetails="If incoming MessageType is expected - send Message via <b>True</b> chain, otherwise <b>False</b> chain is used.", uiResources={"static/rulenode/rulenode-core-config.js", "static/rulenode/rulenode-core-config.css"}, configDirective="tbFilterNodeMessageTypeConfig")
public class TbMsgTypeFilterNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgTypeFilterNode.class);
    TbMsgTypeFilterNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgTypeFilterNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgTypeFilterNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        ctx.tellNext(msg, this.config.getMessageTypes().contains(msg.getType()) ? "True" : "False");
    }

    public void destroy() {
    }
}

