/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import org.thingsboard.rule.engine.action.TbAbstractCustomerActionNode;
import org.thingsboard.rule.engine.action.TbUnassignFromCustomerNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="unassign from customer", configClazz=TbUnassignFromCustomerNodeConfiguration.class, nodeDescription="Unassign Message Originator Entity from Customer", nodeDetails="Finds target Entity Customer by Customer name pattern and then unassign Originator Entity from this customer.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeUnAssignToCustomerConfig", icon="remove_circle")
public class TbUnassignFromCustomerNode
extends TbAbstractCustomerActionNode<TbUnassignFromCustomerNodeConfiguration> {
    @Override
    protected boolean createCustomerIfNotExists() {
        return false;
    }

    @Override
    protected TbUnassignFromCustomerNodeConfiguration loadCustomerNodeActionConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbUnassignFromCustomerNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbUnassignFromCustomerNodeConfiguration.class);
    }

    @Override
    protected void doProcessCustomerAction(TbContext ctx, TbMsg msg, CustomerId customerId) {
        EntityType originatorType = msg.getOriginator().getEntityType();
        switch (originatorType) {
            case DEVICE: {
                this.processUnnasignDevice(ctx, msg);
                break;
            }
            case ASSET: {
                this.processUnnasignAsset(ctx, msg);
                break;
            }
            case ENTITY_VIEW: {
                this.processUnassignEntityView(ctx, msg);
                break;
            }
            case DASHBOARD: {
                this.processUnnasignDashboard(ctx, msg, customerId);
                break;
            }
            default: {
                ctx.tellFailure(msg, (Throwable)new RuntimeException("Unsupported originator type '" + originatorType + "'! Only 'DEVICE', 'ASSET',  'ENTITY_VIEW' or 'DASHBOARD' types are allowed."));
            }
        }
    }

    private void processUnnasignAsset(TbContext ctx, TbMsg msg) {
        ctx.getAssetService().unassignAssetFromCustomer(ctx.getTenantId(), new AssetId(msg.getOriginator().getId()));
    }

    private void processUnnasignDevice(TbContext ctx, TbMsg msg) {
        ctx.getDeviceService().unassignDeviceFromCustomer(ctx.getTenantId(), new DeviceId(msg.getOriginator().getId()));
    }

    private void processUnnasignDashboard(TbContext ctx, TbMsg msg, CustomerId customerId) {
        ctx.getDashboardService().unassignDashboardFromCustomer(ctx.getTenantId(), new DashboardId(msg.getOriginator().getId()), customerId);
    }

    private void processUnassignEntityView(TbContext ctx, TbMsg msg) {
        ctx.getEntityViewService().unassignEntityViewFromCustomer(ctx.getTenantId(), new EntityViewId(msg.getOriginator().getId()));
    }
}

