/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbAbstractAlarmNode;
import org.thingsboard.rule.engine.action.TbCreateAlarmNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.ACTION, name="create alarm", relationTypes={"Created", "Updated", "False"}, configClazz=TbCreateAlarmNodeConfiguration.class, nodeDescription="Create or Update Alarm", nodeDetails="Details - JS function that creates JSON object based on incoming message. This object will be added into Alarm.details field.\nNode output:\nIf alarm was not created, original message is returned. Otherwise new Message returned with type 'ALARM', Alarm object in 'msg' property and 'metadata' will contains one of those properties 'isNewAlarm/isExistingAlarm'. Message payload can be accessed via <code>msg</code> property. For example <code>'temperature = ' + msg.temperature ;</code>. Message metadata can be accessed via <code>metadata</code> property. For example <code>'name = ' + metadata.customerName;</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeCreateAlarmConfig", icon="notifications_active")
public class TbCreateAlarmNode
extends TbAbstractAlarmNode<TbCreateAlarmNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbCreateAlarmNode.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private List<String> relationTypes;

    @Override
    protected TbCreateAlarmNodeConfiguration loadAlarmNodeConfig(TbNodeConfiguration configuration) throws TbNodeException {
        TbCreateAlarmNodeConfiguration nodeConfiguration = (TbCreateAlarmNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCreateAlarmNodeConfiguration.class);
        this.relationTypes = nodeConfiguration.getRelationTypes();
        return nodeConfiguration;
    }

    @Override
    protected ListenableFuture<TbAbstractAlarmNode.AlarmResult> processAlarm(TbContext ctx, TbMsg msg) {
        Alarm msgAlarm;
        String alarmType;
        if (!((TbCreateAlarmNodeConfiguration)this.config).isUseMessageAlarmData()) {
            alarmType = TbNodeUtils.processPattern((String)((TbCreateAlarmNodeConfiguration)this.config).getAlarmType(), (TbMsgMetaData)msg.getMetaData());
            msgAlarm = null;
        } else {
            try {
                msgAlarm = this.getAlarmFromMessage(ctx, msg);
                alarmType = msgAlarm.getType();
            }
            catch (IOException e) {
                ctx.tellFailure(msg, (Throwable)e);
                return null;
            }
        }
        ListenableFuture latest = ctx.getAlarmService().findLatestByOriginatorAndType(ctx.getTenantId(), msg.getOriginator(), alarmType);
        return Futures.transformAsync((ListenableFuture)latest, existingAlarm -> {
            if (existingAlarm == null || existingAlarm.getStatus().isCleared()) {
                return this.createNewAlarm(ctx, msg, msgAlarm);
            }
            return this.updateAlarm(ctx, msg, (Alarm)existingAlarm, msgAlarm);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private Alarm getAlarmFromMessage(TbContext ctx, TbMsg msg) throws IOException {
        Alarm msgAlarm = (Alarm)mapper.readValue(msg.getData(), Alarm.class);
        msgAlarm.setTenantId(ctx.getTenantId());
        if (msgAlarm.getOriginator() == null) {
            msgAlarm.setOriginator(msg.getOriginator());
        }
        if (msgAlarm.getStatus() == null) {
            msgAlarm.setStatus(AlarmStatus.ACTIVE_UNACK);
        }
        return msgAlarm;
    }

    private ListenableFuture<TbAbstractAlarmNode.AlarmResult> createNewAlarm(TbContext ctx, TbMsg msg, Alarm msgAlarm) {
        ListenableFuture asyncAlarm;
        if (msgAlarm != null) {
            asyncAlarm = Futures.immediateFuture((Object)msgAlarm);
        } else {
            ctx.logJsEvalRequest();
            asyncAlarm = Futures.transform(this.buildAlarmDetails(ctx, msg, null), details -> {
                ctx.logJsEvalResponse();
                return this.buildAlarm(msg, (JsonNode)details, ctx.getTenantId());
            }, (Executor)MoreExecutors.directExecutor());
        }
        ListenableFuture asyncCreated = Futures.transform((ListenableFuture)asyncAlarm, alarm -> ctx.getAlarmService().createOrUpdateAlarm(alarm), (Executor)ctx.getDbCallbackExecutor());
        return Futures.transform((ListenableFuture)asyncCreated, alarm -> new TbAbstractAlarmNode.AlarmResult(true, false, false, (Alarm)alarm), (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<TbAbstractAlarmNode.AlarmResult> updateAlarm(TbContext ctx, TbMsg msg, Alarm existingAlarm, Alarm msgAlarm) {
        ctx.logJsEvalRequest();
        ListenableFuture asyncUpdated = Futures.transform(this.buildAlarmDetails(ctx, msg, existingAlarm.getDetails()), details -> {
            ctx.logJsEvalResponse();
            if (msgAlarm != null) {
                existingAlarm.setSeverity(msgAlarm.getSeverity());
                existingAlarm.setPropagate(msgAlarm.isPropagate());
                existingAlarm.setPropagateRelationTypes(msgAlarm.getPropagateRelationTypes());
            } else {
                existingAlarm.setSeverity(((TbCreateAlarmNodeConfiguration)this.config).getSeverity());
                existingAlarm.setPropagate(((TbCreateAlarmNodeConfiguration)this.config).isPropagate());
                existingAlarm.setPropagateRelationTypes(this.relationTypes);
            }
            existingAlarm.setDetails(details);
            existingAlarm.setEndTs(System.currentTimeMillis());
            return ctx.getAlarmService().createOrUpdateAlarm(existingAlarm);
        }, (Executor)ctx.getDbCallbackExecutor());
        return Futures.transform((ListenableFuture)asyncUpdated, a -> new TbAbstractAlarmNode.AlarmResult(false, true, false, (Alarm)a), (Executor)MoreExecutors.directExecutor());
    }

    private Alarm buildAlarm(TbMsg msg, JsonNode details, TenantId tenantId) {
        return Alarm.builder().tenantId(tenantId).originator(msg.getOriginator()).status(AlarmStatus.ACTIVE_UNACK).severity(((TbCreateAlarmNodeConfiguration)this.config).getSeverity()).propagate(((TbCreateAlarmNodeConfiguration)this.config).isPropagate()).type(TbNodeUtils.processPattern((String)((TbCreateAlarmNodeConfiguration)this.config).getAlarmType(), (TbMsgMetaData)msg.getMetaData())).propagateRelationTypes(this.relationTypes).details(details).build();
    }
}

