/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.session.SessionMsgType;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;

@RuleNode(type=ComponentType.ACTION, name="copy to view", configClazz=EmptyNodeConfiguration.class, nodeDescription="Copy attributes from asset/device to entity view and changes message originator to related entity view", nodeDetails="Copy attributes from asset/device to related entity view according to entity view configuration. \n Copy will be done only for attributes that are between start and end dates and according to attribute keys configuration. \nChanges message originator to related entity view and produces new messages according to count of updated entity views", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbNodeEmptyConfig", icon="content_copy")
public class TbCopyAttributesToEntityViewNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCopyAttributesToEntityViewNode.class);
    EmptyNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (EmptyNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, EmptyNodeConfiguration.class);
    }

    public void onMsg(final TbContext ctx, final TbMsg msg) {
        if ("ATTRIBUTES_UPDATED".equals(msg.getType()) || "ATTRIBUTES_DELETED".equals(msg.getType()) || "ACTIVITY_EVENT".equals(msg.getType()) || SessionMsgType.POST_ATTRIBUTES_REQUEST.name().equals(msg.getType())) {
            if (!msg.getMetaData().getData().isEmpty()) {
                long now = System.currentTimeMillis();
                String scope = msg.getType().equals(SessionMsgType.POST_ATTRIBUTES_REQUEST.name()) ? "CLIENT_SCOPE" : msg.getMetaData().getValue("scope");
                ListenableFuture entityViewsFuture = ctx.getEntityViewService().findEntityViewsByTenantIdAndEntityIdAsync(ctx.getTenantId(), msg.getOriginator());
                DonAsynchron.withCallback((ListenableFuture)entityViewsFuture, entityViews -> {
                    for (final EntityView entityView : entityViews) {
                        List filteredAttributes;
                        Collection<String> attributes;
                        long startTime = entityView.getStartTimeMs();
                        long endTime = entityView.getEndTimeMs();
                        if ((endTime == 0L || endTime <= now || startTime >= now) && (endTime != 0L || startTime >= now)) continue;
                        if ("ATTRIBUTES_UPDATED".equals(msg.getType()) || "ACTIVITY_EVENT".equals(msg.getType()) || SessionMsgType.POST_ATTRIBUTES_REQUEST.name().equals(msg.getType())) {
                            attributes = JsonConverter.convertToAttributes((JsonElement)new JsonParser().parse(msg.getData()));
                            filteredAttributes = attributes.stream().filter(attr -> this.attributeContainsInEntityView(scope, attr.getKey(), entityView)).collect(Collectors.toList());
                            ctx.getTelemetryService().saveAndNotify(ctx.getTenantId(), (EntityId)entityView.getId(), scope, filteredAttributes, (FutureCallback)new FutureCallback<Void>(){

                                public void onSuccess(@Nullable Void result) {
                                    TbCopyAttributesToEntityViewNode.this.transformAndTellNext(ctx, msg, entityView);
                                }

                                public void onFailure(Throwable t) {
                                    ctx.tellFailure(msg, t);
                                }
                            });
                            continue;
                        }
                        if (!"ATTRIBUTES_DELETED".equals(msg.getType())) continue;
                        attributes = new ArrayList();
                        for (JsonElement element : new JsonParser().parse(msg.getData()).getAsJsonObject().get("attributes").getAsJsonArray()) {
                            JsonPrimitive value;
                            if (!element.isJsonPrimitive() || !(value = element.getAsJsonPrimitive()).isString()) continue;
                            attributes.add(value.getAsString());
                        }
                        filteredAttributes = attributes.stream().filter(attr -> this.attributeContainsInEntityView(scope, (String)attr, entityView)).collect(Collectors.toList());
                        if (filteredAttributes.isEmpty()) continue;
                        ctx.getAttributesService().removeAll(ctx.getTenantId(), (EntityId)entityView.getId(), scope, filteredAttributes);
                        this.transformAndTellNext(ctx, msg, entityView);
                    }
                    ctx.ack(msg);
                }, t -> ctx.tellFailure(msg, t));
            } else {
                ctx.tellFailure(msg, (Throwable)new IllegalArgumentException("Message metadata is empty"));
            }
        } else {
            ctx.tellFailure(msg, (Throwable)new IllegalArgumentException("Unsupported msg type [" + msg.getType() + "]"));
        }
    }

    private void transformAndTellNext(TbContext ctx, TbMsg msg, EntityView entityView) {
        ctx.enqueueForTellNext(ctx.newMsg(msg.getQueueName(), msg.getType(), (EntityId)entityView.getId(), msg.getMetaData(), msg.getData()), TbRelationTypes.SUCCESS);
    }

    private boolean attributeContainsInEntityView(String scope, String attrKey, EntityView entityView) {
        switch (scope) {
            case "CLIENT_SCOPE": {
                return entityView.getKeys().getAttributes().getCs().contains(attrKey);
            }
            case "SERVER_SCOPE": {
                return entityView.getKeys().getAttributes().getSs().contains(attrKey);
            }
            case "SHARED_SCOPE": {
                return entityView.getKeys().getAttributes().getSh().contains(attrKey);
            }
        }
        return false;
    }

    public void destroy() {
    }
}

