/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.action.TbAbstractAlarmNodeConfiguration;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public abstract class TbAbstractAlarmNode<C extends TbAbstractAlarmNodeConfiguration>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractAlarmNode.class);
    static final String PREV_ALARM_DETAILS = "prevAlarmDetails";
    static final String IS_NEW_ALARM = "isNewAlarm";
    static final String IS_EXISTING_ALARM = "isExistingAlarm";
    static final String IS_CLEARED_ALARM = "isClearedAlarm";
    private final ObjectMapper mapper = new ObjectMapper();
    protected C config;
    private ScriptEngine buildDetailsJsEngine;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = this.loadAlarmNodeConfig(configuration);
        this.buildDetailsJsEngine = ctx.createJsScriptEngine(((TbAbstractAlarmNodeConfiguration)this.config).getAlarmDetailsBuildJs(), new String[0]);
    }

    protected abstract C loadAlarmNodeConfig(TbNodeConfiguration var1) throws TbNodeException;

    public void onMsg(TbContext ctx, TbMsg msg) {
        DonAsynchron.withCallback(this.processAlarm(ctx, msg), alarmResult -> {
            if (alarmResult.alarm == null) {
                ctx.tellNext(msg, "False");
            } else if (alarmResult.isCreated) {
                ctx.enqueue(ctx.alarmCreatedMsg(alarmResult.alarm, ctx.getSelfId()), () -> ctx.tellNext(this.toAlarmMsg(ctx, (AlarmResult)alarmResult, msg), "Created"), throwable -> ctx.tellFailure(this.toAlarmMsg(ctx, (AlarmResult)alarmResult, msg), throwable));
            } else if (alarmResult.isUpdated) {
                ctx.tellNext(this.toAlarmMsg(ctx, (AlarmResult)alarmResult, msg), "Updated");
            } else if (alarmResult.isCleared) {
                ctx.tellNext(this.toAlarmMsg(ctx, (AlarmResult)alarmResult, msg), "Cleared");
            } else {
                ctx.tellSuccess(msg);
            }
        }, t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    protected abstract ListenableFuture<AlarmResult> processAlarm(TbContext var1, TbMsg var2);

    protected ListenableFuture<JsonNode> buildAlarmDetails(TbContext ctx, TbMsg msg, JsonNode previousDetails) {
        try {
            TbMsg dummyMsg = msg;
            if (previousDetails != null) {
                TbMsgMetaData metaData = msg.getMetaData().copy();
                metaData.putValue(PREV_ALARM_DETAILS, this.mapper.writeValueAsString((Object)previousDetails));
                dummyMsg = ctx.transformMsg(msg, msg.getType(), msg.getOriginator(), metaData, msg.getData());
            }
            return this.buildDetailsJsEngine.executeJsonAsync(dummyMsg);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private TbMsg toAlarmMsg(TbContext ctx, AlarmResult alarmResult, TbMsg originalMsg) {
        JsonNode jsonNodes = this.mapper.valueToTree((Object)alarmResult.alarm);
        String data = jsonNodes.toString();
        TbMsgMetaData metaData = originalMsg.getMetaData().copy();
        if (alarmResult.isCreated) {
            metaData.putValue(IS_NEW_ALARM, Boolean.TRUE.toString());
        } else if (alarmResult.isUpdated) {
            metaData.putValue(IS_EXISTING_ALARM, Boolean.TRUE.toString());
        } else if (alarmResult.isCleared) {
            metaData.putValue(IS_CLEARED_ALARM, Boolean.TRUE.toString());
        }
        return ctx.transformMsg(originalMsg, "ALARM", originalMsg.getOriginator(), metaData, data);
    }

    public void destroy() {
        if (this.buildDetailsJsEngine != null) {
            this.buildDetailsJsEngine.destroy();
        }
    }

    protected static class AlarmResult {
        boolean isCreated;
        boolean isUpdated;
        boolean isCleared;
        Alarm alarm;

        AlarmResult(boolean isCreated, boolean isUpdated, boolean isCleared, Alarm alarm) {
            this.isCreated = isCreated;
            this.isUpdated = isUpdated;
            this.isCleared = isCleared;
            this.alarm = alarm;
        }
    }
}

