/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public class TbNodeUtils {
    private static final Pattern DATA_PATTERN = Pattern.compile("(\\$\\[)(.*?)(])");

    public static <T> T convert(TbNodeConfiguration configuration, Class<T> clazz) throws TbNodeException {
        try {
            return (T)JacksonUtil.treeToValue((JsonNode)configuration.getData(), clazz);
        }
        catch (IllegalArgumentException e) {
            throw new TbNodeException(e, true);
        }
    }

    public static List<String> processPatterns(List<String> patterns, TbMsg tbMsg) {
        if (!CollectionUtils.isEmpty(patterns)) {
            return patterns.stream().map(p -> TbNodeUtils.processPattern(p, tbMsg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String processPattern(String pattern, TbMsg tbMsg) {
        try {
            String result = TbNodeUtils.processPattern(pattern, tbMsg.getMetaData());
            JsonNode json = JacksonUtil.toJsonNode((String)tbMsg.getData());
            if (json.isObject()) {
                Matcher matcher = DATA_PATTERN.matcher(result);
                while (matcher.find()) {
                    String group = matcher.group(2);
                    String[] keys = group.split("\\.");
                    JsonNode jsonNode = json;
                    for (String key : keys) {
                        if (StringUtils.isEmpty((String)key) || jsonNode == null) {
                            jsonNode = null;
                            break;
                        }
                        jsonNode = jsonNode.get(key);
                    }
                    if (jsonNode == null || !jsonNode.isValueNode()) continue;
                    result = result.replace(TbNodeUtils.formatDataVarTemplate(group), jsonNode.asText());
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process pattern!", e);
        }
    }

    @Deprecated(since="3.6.1", forRemoval=true)
    public static List<String> processPatterns(List<String> patterns, TbMsgMetaData metaData) {
        if (!CollectionUtils.isEmpty(patterns)) {
            return patterns.stream().map(p -> TbNodeUtils.processPattern(p, metaData)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String processPattern(String pattern, TbMsgMetaData metaData) {
        return TbNodeUtils.processTemplate(pattern, metaData.values());
    }

    public static String processTemplate(String template, Map<String, String> data) {
        String result = template;
        for (Map.Entry<String, String> kv : data.entrySet()) {
            result = TbNodeUtils.processVar(result, kv.getKey(), kv.getValue());
        }
        return result;
    }

    private static String processVar(String pattern, String key, String val) {
        return pattern.replace(TbNodeUtils.formatMetadataVarTemplate(key), val);
    }

    static String formatDataVarTemplate(String key) {
        return "$[" + key + "]";
    }

    static String formatMetadataVarTemplate(String key) {
        return "${" + key + "}";
    }
}

