/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.SettableFuture;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.thingsboard.common.util.NoOpFutureCallback;
import org.thingsboard.rule.engine.api.CalculatedFieldSystemAwareRequest;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;

public class TimeseriesSaveRequest
implements CalculatedFieldSystemAwareRequest {
    private final TenantId tenantId;
    private final CustomerId customerId;
    private final EntityId entityId;
    private final List<TsKvEntry> entries;
    private final long ttl;
    private final Strategy strategy;
    private final List<CalculatedFieldId> previousCalculatedFieldIds;
    private final UUID tbMsgId;
    private final TbMsgType tbMsgType;
    private final FutureCallback<Void> callback;

    public static Builder builder() {
        return new Builder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public List<TsKvEntry> getEntries() {
        return this.entries;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public List<CalculatedFieldId> getPreviousCalculatedFieldIds() {
        return this.previousCalculatedFieldIds;
    }

    @Override
    public UUID getTbMsgId() {
        return this.tbMsgId;
    }

    @Override
    public TbMsgType getTbMsgType() {
        return this.tbMsgType;
    }

    public FutureCallback<Void> getCallback() {
        return this.callback;
    }

    @ConstructorProperties(value={"tenantId", "customerId", "entityId", "entries", "ttl", "strategy", "previousCalculatedFieldIds", "tbMsgId", "tbMsgType", "callback"})
    private TimeseriesSaveRequest(TenantId tenantId, CustomerId customerId, EntityId entityId, List<TsKvEntry> entries, long ttl, Strategy strategy, List<CalculatedFieldId> previousCalculatedFieldIds, UUID tbMsgId, TbMsgType tbMsgType, FutureCallback<Void> callback) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.entityId = entityId;
        this.entries = entries;
        this.ttl = ttl;
        this.strategy = strategy;
        this.previousCalculatedFieldIds = previousCalculatedFieldIds;
        this.tbMsgId = tbMsgId;
        this.tbMsgType = tbMsgType;
        this.callback = callback;
    }

    public static class Builder {
        private TenantId tenantId;
        private CustomerId customerId;
        private EntityId entityId;
        private List<TsKvEntry> entries;
        private long ttl;
        private Strategy strategy;
        private List<CalculatedFieldId> previousCalculatedFieldIds;
        private UUID tbMsgId;
        private TbMsgType tbMsgType;
        private FutureCallback<Void> callback;

        Builder() {
        }

        public Builder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder entries(List<TsKvEntry> entries) {
            this.entries = entries;
            return this;
        }

        public Builder entry(TsKvEntry entry) {
            return this.entries(List.of(entry));
        }

        public Builder entry(KvEntry kvEntry) {
            return this.entry((TsKvEntry)new BasicTsKvEntry(System.currentTimeMillis(), kvEntry));
        }

        public Builder ttl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder strategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder previousCalculatedFieldIds(List<CalculatedFieldId> previousCalculatedFieldIds) {
            this.previousCalculatedFieldIds = previousCalculatedFieldIds;
            return this;
        }

        public Builder tbMsgId(UUID tbMsgId) {
            this.tbMsgId = tbMsgId;
            return this;
        }

        public Builder tbMsgType(TbMsgType tbMsgType) {
            this.tbMsgType = tbMsgType;
            return this;
        }

        public Builder callback(FutureCallback<Void> callback) {
            this.callback = callback;
            return this;
        }

        public Builder future(final SettableFuture<Void> future) {
            return this.callback(new FutureCallback<Void>(){

                public void onSuccess(Void result) {
                    future.set((Object)result);
                }

                public void onFailure(Throwable t) {
                    future.setException(t);
                }
            });
        }

        public TimeseriesSaveRequest build() {
            return new TimeseriesSaveRequest(this.tenantId, this.customerId, this.entityId, this.entries, this.ttl, Objects.requireNonNullElse(this.strategy, Strategy.PROCESS_ALL), this.previousCalculatedFieldIds, this.tbMsgId, this.tbMsgType, (FutureCallback<Void>)Objects.requireNonNullElse(this.callback, NoOpFutureCallback.instance()));
        }
    }

    public record Strategy(boolean saveTimeseries, boolean saveLatest, boolean sendWsUpdate, boolean processCalculatedFields) {
        public static final Strategy PROCESS_ALL = new Strategy(true, true, true, true);
        public static final Strategy WS_ONLY = new Strategy(false, false, true, false);
        public static final Strategy LATEST_AND_WS = new Strategy(false, true, true, false);
        public static final Strategy SKIP_ALL = new Strategy(false, false, false, false);
    }
}

