/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import org.thingsboard.rule.engine.api.CalculatedFieldSystemAwareRequest;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.DeleteTsKvQuery;
import org.thingsboard.server.common.data.msg.TbMsgType;

public class TimeseriesDeleteRequest
implements CalculatedFieldSystemAwareRequest {
    private final TenantId tenantId;
    private final EntityId entityId;
    private final List<String> keys;
    private final List<DeleteTsKvQuery> deleteHistoryQueries;
    private final List<CalculatedFieldId> previousCalculatedFieldIds;
    private final UUID tbMsgId;
    private final TbMsgType tbMsgType;
    private final FutureCallback<List<String>> callback;

    public static Builder builder() {
        return new Builder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public List<DeleteTsKvQuery> getDeleteHistoryQueries() {
        return this.deleteHistoryQueries;
    }

    @Override
    public List<CalculatedFieldId> getPreviousCalculatedFieldIds() {
        return this.previousCalculatedFieldIds;
    }

    @Override
    public UUID getTbMsgId() {
        return this.tbMsgId;
    }

    @Override
    public TbMsgType getTbMsgType() {
        return this.tbMsgType;
    }

    public FutureCallback<List<String>> getCallback() {
        return this.callback;
    }

    public String toString() {
        return "TimeseriesDeleteRequest(tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", keys=" + String.valueOf(this.getKeys()) + ", deleteHistoryQueries=" + String.valueOf(this.getDeleteHistoryQueries()) + ", previousCalculatedFieldIds=" + String.valueOf(this.getPreviousCalculatedFieldIds()) + ", tbMsgId=" + String.valueOf(this.getTbMsgId()) + ", tbMsgType=" + String.valueOf(this.getTbMsgType()) + ", callback=" + String.valueOf(this.getCallback()) + ")";
    }

    @ConstructorProperties(value={"tenantId", "entityId", "keys", "deleteHistoryQueries", "previousCalculatedFieldIds", "tbMsgId", "tbMsgType", "callback"})
    private TimeseriesDeleteRequest(TenantId tenantId, EntityId entityId, List<String> keys, List<DeleteTsKvQuery> deleteHistoryQueries, List<CalculatedFieldId> previousCalculatedFieldIds, UUID tbMsgId, TbMsgType tbMsgType, FutureCallback<List<String>> callback) {
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.keys = keys;
        this.deleteHistoryQueries = deleteHistoryQueries;
        this.previousCalculatedFieldIds = previousCalculatedFieldIds;
        this.tbMsgId = tbMsgId;
        this.tbMsgType = tbMsgType;
        this.callback = callback;
    }

    public static class Builder {
        private TenantId tenantId;
        private EntityId entityId;
        private List<String> keys;
        private List<DeleteTsKvQuery> deleteHistoryQueries;
        private List<CalculatedFieldId> previousCalculatedFieldIds;
        private UUID tbMsgId;
        private TbMsgType tbMsgType;
        private FutureCallback<List<String>> callback;

        Builder() {
        }

        public Builder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder keys(List<String> keys) {
            this.keys = keys;
            return this;
        }

        public Builder deleteHistoryQueries(List<DeleteTsKvQuery> deleteHistoryQueries) {
            this.deleteHistoryQueries = deleteHistoryQueries;
            return this;
        }

        public Builder previousCalculatedFieldIds(List<CalculatedFieldId> previousCalculatedFieldIds) {
            this.previousCalculatedFieldIds = previousCalculatedFieldIds;
            return this;
        }

        public Builder tbMsgId(UUID tbMsgId) {
            this.tbMsgId = tbMsgId;
            return this;
        }

        public Builder tbMsgType(TbMsgType tbMsgType) {
            this.tbMsgType = tbMsgType;
            return this;
        }

        public Builder callback(FutureCallback<List<String>> callback) {
            this.callback = callback;
            return this;
        }

        public TimeseriesDeleteRequest build() {
            return new TimeseriesDeleteRequest(this.tenantId, this.entityId, this.keys, this.deleteHistoryQueries, this.previousCalculatedFieldIds, this.tbMsgId, this.tbMsgType, this.callback);
        }
    }
}

