/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import io.netty.channel.EventLoopGroup;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.thingsboard.common.util.ExecutorProvider;
import org.thingsboard.common.util.ListeningExecutor;
import org.thingsboard.rule.engine.api.DeviceStateManager;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.rule.engine.api.RuleEngineAlarmService;
import org.thingsboard.rule.engine.api.RuleEngineApiUsageStateService;
import org.thingsboard.rule.engine.api.RuleEngineAssetProfileCache;
import org.thingsboard.rule.engine.api.RuleEngineCalculatedFieldQueueService;
import org.thingsboard.rule.engine.api.RuleEngineDeviceProfileCache;
import org.thingsboard.rule.engine.api.RuleEngineRpcService;
import org.thingsboard.rule.engine.api.RuleEngineTelemetryService;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.SmsService;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.notification.SlackService;
import org.thingsboard.rule.engine.api.sms.SmsSenderFactory;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.rule.RuleNodeState;
import org.thingsboard.server.common.data.script.ScriptLanguage;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.alarm.AlarmCommentService;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.audit.AuditLogService;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.dao.mobile.MobileAppBundleService;
import org.thingsboard.server.dao.mobile.MobileAppService;
import org.thingsboard.server.dao.nosql.CassandraStatementTask;
import org.thingsboard.server.dao.nosql.TbResultSetFuture;
import org.thingsboard.server.dao.notification.NotificationRequestService;
import org.thingsboard.server.dao.notification.NotificationRuleService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.queue.QueueStatsService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;

public interface TbContext {
    public void tellSuccess(TbMsg var1);

    public void tellNext(TbMsg var1, String var2);

    public void tellNext(TbMsg var1, Set<String> var2);

    public void tellSelf(TbMsg var1, long var2);

    public void tellFailure(TbMsg var1, Throwable var2);

    public void enqueue(TbMsg var1, Runnable var2, Consumer<Throwable> var3);

    public void enqueue(TbMsg var1, String var2, Runnable var3, Consumer<Throwable> var4);

    public void input(TbMsg var1, RuleChainId var2);

    public void output(TbMsg var1, String var2);

    public void enqueueForTellFailure(TbMsg var1, String var2);

    public void enqueueForTellFailure(TbMsg var1, Throwable var2);

    public void enqueueForTellNext(TbMsg var1, String var2);

    public void enqueueForTellNext(TbMsg var1, Set<String> var2);

    public void enqueueForTellNext(TbMsg var1, String var2, Runnable var3, Consumer<Throwable> var4);

    public void enqueueForTellNext(TbMsg var1, Set<String> var2, Runnable var3, Consumer<Throwable> var4);

    public void enqueueForTellNext(TbMsg var1, String var2, String var3, Runnable var4, Consumer<Throwable> var5);

    public void enqueueForTellNext(TbMsg var1, String var2, Set<String> var3, Runnable var4, Consumer<Throwable> var5);

    public void ack(TbMsg var1);

    @Deprecated(since="3.6.0")
    public TbMsg newMsg(String var1, String var2, EntityId var3, CustomerId var4, TbMsgMetaData var5, String var6);

    @Deprecated(since="3.6.0", forRemoval=true)
    public TbMsg transformMsg(TbMsg var1, String var2, EntityId var3, TbMsgMetaData var4, String var5);

    public TbMsg newMsg(String var1, TbMsgType var2, EntityId var3, TbMsgMetaData var4, String var5);

    public TbMsg newMsg(String var1, TbMsgType var2, EntityId var3, CustomerId var4, TbMsgMetaData var5, String var6);

    public TbMsg transformMsg(TbMsg var1, TbMsgType var2, EntityId var3, TbMsgMetaData var4, String var5);

    public TbMsg transformMsg(TbMsg var1, TbMsgMetaData var2, String var3);

    public TbMsg transformMsgOriginator(TbMsg var1, EntityId var2);

    public TbMsg customerCreatedMsg(Customer var1, RuleNodeId var2);

    public TbMsg deviceCreatedMsg(Device var1, RuleNodeId var2);

    public TbMsg assetCreatedMsg(Asset var1, RuleNodeId var2);

    @Deprecated(since="3.6.0", forRemoval=true)
    public TbMsg alarmActionMsg(Alarm var1, RuleNodeId var2, String var3);

    public TbMsg alarmActionMsg(Alarm var1, RuleNodeId var2, TbMsgType var3);

    public TbMsg attributesUpdatedActionMsg(EntityId var1, RuleNodeId var2, String var3, List<AttributeKvEntry> var4);

    public TbMsg attributesDeletedActionMsg(EntityId var1, RuleNodeId var2, String var3, List<String> var4);

    public void schedule(Runnable var1, long var2, TimeUnit var4);

    public void checkTenantEntity(EntityId var1) throws TbNodeException;

    public boolean isLocalEntity(EntityId var1);

    public RuleNodeId getSelfId();

    public RuleNode getSelf();

    public String getRuleChainName();

    public String getQueueName();

    public TenantId getTenantId();

    public AttributesService getAttributesService();

    public CustomerService getCustomerService();

    public TenantService getTenantService();

    public UserService getUserService();

    public AssetService getAssetService();

    public DeviceService getDeviceService();

    public DeviceProfileService getDeviceProfileService();

    public AssetProfileService getAssetProfileService();

    public DeviceCredentialsService getDeviceCredentialsService();

    public DeviceStateManager getDeviceStateManager();

    public String getDeviceStateNodeRateLimitConfig();

    public TbClusterService getClusterService();

    public DashboardService getDashboardService();

    public RuleEngineAlarmService getAlarmService();

    public AlarmCommentService getAlarmCommentService();

    public RuleChainService getRuleChainService();

    public RuleEngineRpcService getRpcService();

    public RuleEngineTelemetryService getTelemetryService();

    public TimeseriesService getTimeseriesService();

    public RelationService getRelationService();

    public EntityViewService getEntityViewService();

    public ResourceService getResourceService();

    public OtaPackageService getOtaPackageService();

    public RuleEngineDeviceProfileCache getDeviceProfileCache();

    public RuleEngineAssetProfileCache getAssetProfileCache();

    public EdgeService getEdgeService();

    public EdgeEventService getEdgeEventService();

    public QueueService getQueueService();

    public QueueStatsService getQueueStatsService();

    public ListeningExecutor getMailExecutor();

    public ListeningExecutor getSmsExecutor();

    public ListeningExecutor getDbCallbackExecutor();

    public ListeningExecutor getExternalCallExecutor();

    public ListeningExecutor getNotificationExecutor();

    public ExecutorProvider getPubSubRuleNodeExecutorProvider();

    public MailService getMailService(boolean var1);

    public SmsService getSmsService();

    public SmsSenderFactory getSmsSenderFactory();

    public NotificationCenter getNotificationCenter();

    public NotificationTargetService getNotificationTargetService();

    public NotificationTemplateService getNotificationTemplateService();

    public NotificationRequestService getNotificationRequestService();

    public NotificationRuleService getNotificationRuleService();

    public OAuth2ClientService getOAuth2ClientService();

    public DomainService getDomainService();

    public MobileAppService getMobileAppService();

    public MobileAppBundleService getMobileAppBundleService();

    public SlackService getSlackService();

    public CalculatedFieldService getCalculatedFieldService();

    public RuleEngineCalculatedFieldQueueService getCalculatedFieldQueueService();

    public boolean isExternalNodeForceAck();

    @Deprecated
    public ScriptEngine createJsScriptEngine(String var1, String ... var2);

    public ScriptEngine createScriptEngine(ScriptLanguage var1, String var2, String ... var3);

    public String getServiceId();

    public EventLoopGroup getSharedEventLoop();

    public CassandraCluster getCassandraCluster();

    public TbResultSetFuture submitCassandraReadTask(CassandraStatementTask var1);

    public TbResultSetFuture submitCassandraWriteTask(CassandraStatementTask var1);

    public PageData<RuleNodeState> findRuleNodeStates(PageLink var1);

    public RuleNodeState findRuleNodeStateForEntity(EntityId var1);

    public void removeRuleNodeStateForEntity(EntityId var1);

    public RuleNodeState saveRuleNodeState(RuleNodeState var1);

    public void clearRuleNodeStates();

    public void addTenantProfileListener(Consumer<TenantProfile> var1);

    public void addDeviceProfileListeners(Consumer<DeviceProfile> var1, BiConsumer<DeviceId, DeviceProfile> var2);

    public void addAssetProfileListeners(Consumer<AssetProfile> var1, BiConsumer<AssetId, AssetProfile> var2);

    public void removeListeners();

    public TenantProfile getTenantProfile();

    public WidgetsBundleService getWidgetBundleService();

    public WidgetTypeService getWidgetTypeService();

    public RuleEngineApiUsageStateService getRuleEngineApiUsageStateService();

    public EntityService getEntityService();

    public EventService getEventService();

    public AuditLogService getAuditLogService();
}

