/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmQueryV2;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataQuery;

public interface RuleEngineAlarmService {
    public AlarmApiCallResult createAlarm(AlarmCreateOrUpdateActiveRequest var1);

    public AlarmApiCallResult updateAlarm(AlarmUpdateRequest var1);

    public AlarmApiCallResult acknowledgeAlarm(TenantId var1, AlarmId var2, long var3);

    public AlarmApiCallResult clearAlarm(TenantId var1, AlarmId var2, long var3, JsonNode var5);

    public AlarmApiCallResult assignAlarm(TenantId var1, AlarmId var2, UserId var3, long var4);

    public AlarmApiCallResult unassignAlarm(TenantId var1, AlarmId var2, long var3);

    public Boolean deleteAlarm(TenantId var1, AlarmId var2);

    public ListenableFuture<Alarm> findAlarmByIdAsync(TenantId var1, AlarmId var2);

    public Alarm findAlarmById(TenantId var1, AlarmId var2);

    public Alarm findLatestActiveByOriginatorAndType(TenantId var1, EntityId var2, String var3);

    public Alarm findLatestByOriginatorAndType(TenantId var1, EntityId var2, String var3);

    public AlarmInfo findAlarmInfoById(TenantId var1, AlarmId var2);

    default public ListenableFuture<AlarmInfo> findAlarmInfoByIdAsync(TenantId tenantId, AlarmId alarmId) {
        return Futures.immediateFuture((Object)this.findAlarmInfoById(tenantId, alarmId));
    }

    public PageData<AlarmInfo> findAlarms(TenantId var1, AlarmQuery var2);

    public PageData<AlarmInfo> findCustomerAlarms(TenantId var1, CustomerId var2, AlarmQuery var3);

    public PageData<AlarmInfo> findAlarmsV2(TenantId var1, AlarmQueryV2 var2);

    public PageData<AlarmInfo> findCustomerAlarmsV2(TenantId var1, CustomerId var2, AlarmQueryV2 var3);

    public AlarmSeverity findHighestAlarmSeverity(TenantId var1, EntityId var2, AlarmSearchStatus var3, AlarmStatus var4, String var5);

    public PageData<AlarmData> findAlarmDataByQueryForEntities(TenantId var1, AlarmDataQuery var2, Collection<EntityId> var3);

    public PageData<EntitySubtype> findAlarmTypesByTenantId(TenantId var1, PageLink var2);
}

