/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.SettableFuture;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.thingsboard.common.util.NoOpFutureCallback;
import org.thingsboard.rule.engine.api.CalculatedFieldSystemAwareRequest;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;

public class AttributesSaveRequest
implements CalculatedFieldSystemAwareRequest {
    private final TenantId tenantId;
    private final EntityId entityId;
    private final AttributeScope scope;
    private final List<AttributeKvEntry> entries;
    private final boolean notifyDevice;
    private final Strategy strategy;
    private final List<CalculatedFieldId> previousCalculatedFieldIds;
    private final UUID tbMsgId;
    private final TbMsgType tbMsgType;
    private final FutureCallback<Void> callback;

    public static Builder builder() {
        return new Builder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public AttributeScope getScope() {
        return this.scope;
    }

    public List<AttributeKvEntry> getEntries() {
        return this.entries;
    }

    public boolean isNotifyDevice() {
        return this.notifyDevice;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public List<CalculatedFieldId> getPreviousCalculatedFieldIds() {
        return this.previousCalculatedFieldIds;
    }

    @Override
    public UUID getTbMsgId() {
        return this.tbMsgId;
    }

    @Override
    public TbMsgType getTbMsgType() {
        return this.tbMsgType;
    }

    public FutureCallback<Void> getCallback() {
        return this.callback;
    }

    public String toString() {
        return "AttributesSaveRequest(tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", scope=" + String.valueOf(this.getScope()) + ", entries=" + String.valueOf(this.getEntries()) + ", notifyDevice=" + this.isNotifyDevice() + ", strategy=" + String.valueOf(this.getStrategy()) + ", previousCalculatedFieldIds=" + String.valueOf(this.getPreviousCalculatedFieldIds()) + ", tbMsgId=" + String.valueOf(this.getTbMsgId()) + ", tbMsgType=" + String.valueOf(this.getTbMsgType()) + ", callback=" + String.valueOf(this.getCallback()) + ")";
    }

    @ConstructorProperties(value={"tenantId", "entityId", "scope", "entries", "notifyDevice", "strategy", "previousCalculatedFieldIds", "tbMsgId", "tbMsgType", "callback"})
    private AttributesSaveRequest(TenantId tenantId, EntityId entityId, AttributeScope scope, List<AttributeKvEntry> entries, boolean notifyDevice, Strategy strategy, List<CalculatedFieldId> previousCalculatedFieldIds, UUID tbMsgId, TbMsgType tbMsgType, FutureCallback<Void> callback) {
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.scope = scope;
        this.entries = entries;
        this.notifyDevice = notifyDevice;
        this.strategy = strategy;
        this.previousCalculatedFieldIds = previousCalculatedFieldIds;
        this.tbMsgId = tbMsgId;
        this.tbMsgType = tbMsgType;
        this.callback = callback;
    }

    public static class Builder {
        private TenantId tenantId;
        private EntityId entityId;
        private AttributeScope scope;
        private List<AttributeKvEntry> entries;
        private boolean notifyDevice = true;
        private Strategy strategy;
        private List<CalculatedFieldId> previousCalculatedFieldIds;
        private UUID tbMsgId;
        private TbMsgType tbMsgType;
        private FutureCallback<Void> callback;

        Builder() {
        }

        public Builder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder scope(AttributeScope scope) {
            this.scope = scope;
            return this;
        }

        @Deprecated
        public Builder scope(String scope) {
            try {
                this.scope = AttributeScope.valueOf((String)scope);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid attribute scope '" + scope + "'");
            }
            return this;
        }

        public Builder entries(List<AttributeKvEntry> entries) {
            this.entries = entries;
            return this;
        }

        public Builder entry(AttributeKvEntry entry) {
            return this.entries(List.of(entry));
        }

        public Builder entry(KvEntry kvEntry) {
            return this.entry((AttributeKvEntry)new BaseAttributeKvEntry(kvEntry, System.currentTimeMillis()));
        }

        public Builder notifyDevice(boolean notifyDevice) {
            this.notifyDevice = notifyDevice;
            return this;
        }

        public Builder strategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder previousCalculatedFieldIds(List<CalculatedFieldId> previousCalculatedFieldIds) {
            this.previousCalculatedFieldIds = previousCalculatedFieldIds;
            return this;
        }

        public Builder tbMsgId(UUID tbMsgId) {
            this.tbMsgId = tbMsgId;
            return this;
        }

        public Builder tbMsgType(TbMsgType tbMsgType) {
            this.tbMsgType = tbMsgType;
            return this;
        }

        public Builder callback(FutureCallback<Void> callback) {
            this.callback = callback;
            return this;
        }

        public Builder future(final SettableFuture<Void> future) {
            return this.callback(new FutureCallback<Void>(){

                public void onSuccess(Void result) {
                    future.set((Object)result);
                }

                public void onFailure(Throwable t) {
                    future.setException(t);
                }
            });
        }

        public AttributesSaveRequest build() {
            return new AttributesSaveRequest(this.tenantId, this.entityId, this.scope, this.entries, this.notifyDevice, Objects.requireNonNullElse(this.strategy, Strategy.PROCESS_ALL), this.previousCalculatedFieldIds, this.tbMsgId, this.tbMsgType, (FutureCallback<Void>)Objects.requireNonNullElse(this.callback, NoOpFutureCallback.instance()));
        }
    }

    public record Strategy(boolean saveAttributes, boolean sendWsUpdate, boolean processCalculatedFields) {
        public static final Strategy PROCESS_ALL = new Strategy(true, true, true);
        public static final Strategy WS_ONLY = new Strategy(false, true, false);
        public static final Strategy SKIP_ALL = new Strategy(false, false, false);
    }
}

