/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.SettableFuture;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.thingsboard.common.util.NoOpFutureCallback;
import org.thingsboard.rule.engine.api.CalculatedFieldSystemAwareRequest;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;

public class AttributesDeleteRequest
implements CalculatedFieldSystemAwareRequest {
    private final TenantId tenantId;
    private final EntityId entityId;
    private final AttributeScope scope;
    private final List<String> keys;
    private final boolean notifyDevice;
    private final List<CalculatedFieldId> previousCalculatedFieldIds;
    private final UUID tbMsgId;
    private final TbMsgType tbMsgType;
    private final FutureCallback<Void> callback;

    public static Builder builder() {
        return new Builder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public AttributeScope getScope() {
        return this.scope;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public boolean isNotifyDevice() {
        return this.notifyDevice;
    }

    @Override
    public List<CalculatedFieldId> getPreviousCalculatedFieldIds() {
        return this.previousCalculatedFieldIds;
    }

    @Override
    public UUID getTbMsgId() {
        return this.tbMsgId;
    }

    @Override
    public TbMsgType getTbMsgType() {
        return this.tbMsgType;
    }

    public FutureCallback<Void> getCallback() {
        return this.callback;
    }

    public String toString() {
        return "AttributesDeleteRequest(tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", scope=" + String.valueOf(this.getScope()) + ", keys=" + String.valueOf(this.getKeys()) + ", notifyDevice=" + this.isNotifyDevice() + ", previousCalculatedFieldIds=" + String.valueOf(this.getPreviousCalculatedFieldIds()) + ", tbMsgId=" + String.valueOf(this.getTbMsgId()) + ", tbMsgType=" + String.valueOf(this.getTbMsgType()) + ", callback=" + String.valueOf(this.getCallback()) + ")";
    }

    @ConstructorProperties(value={"tenantId", "entityId", "scope", "keys", "notifyDevice", "previousCalculatedFieldIds", "tbMsgId", "tbMsgType", "callback"})
    private AttributesDeleteRequest(TenantId tenantId, EntityId entityId, AttributeScope scope, List<String> keys, boolean notifyDevice, List<CalculatedFieldId> previousCalculatedFieldIds, UUID tbMsgId, TbMsgType tbMsgType, FutureCallback<Void> callback) {
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.scope = scope;
        this.keys = keys;
        this.notifyDevice = notifyDevice;
        this.previousCalculatedFieldIds = previousCalculatedFieldIds;
        this.tbMsgId = tbMsgId;
        this.tbMsgType = tbMsgType;
        this.callback = callback;
    }

    public static class Builder {
        private TenantId tenantId;
        private EntityId entityId;
        private AttributeScope scope;
        private List<String> keys;
        private boolean notifyDevice;
        private List<CalculatedFieldId> previousCalculatedFieldIds;
        private UUID tbMsgId;
        private TbMsgType tbMsgType;
        private FutureCallback<Void> callback;

        Builder() {
        }

        public Builder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder scope(AttributeScope scope) {
            this.scope = scope;
            return this;
        }

        @Deprecated
        public Builder scope(String scope) {
            try {
                this.scope = AttributeScope.valueOf((String)scope);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid attribute scope '" + scope + "'");
            }
            return this;
        }

        public Builder keys(List<String> keys) {
            this.keys = keys;
            return this;
        }

        public Builder notifyDevice(boolean notifyDevice) {
            this.notifyDevice = notifyDevice;
            return this;
        }

        public Builder previousCalculatedFieldIds(List<CalculatedFieldId> previousCalculatedFieldIds) {
            this.previousCalculatedFieldIds = previousCalculatedFieldIds;
            return this;
        }

        public Builder tbMsgId(UUID tbMsgId) {
            this.tbMsgId = tbMsgId;
            return this;
        }

        public Builder tbMsgType(TbMsgType tbMsgType) {
            this.tbMsgType = tbMsgType;
            return this;
        }

        public Builder callback(FutureCallback<Void> callback) {
            this.callback = callback;
            return this;
        }

        public Builder future(final SettableFuture<Void> future) {
            return this.callback(new FutureCallback<Void>(){

                public void onSuccess(Void result) {
                    future.set((Object)result);
                }

                public void onFailure(Throwable t) {
                    future.setException(t);
                }
            });
        }

        public AttributesDeleteRequest build() {
            return new AttributesDeleteRequest(this.tenantId, this.entityId, this.scope, this.keys, this.notifyDevice, this.previousCalculatedFieldIds, this.tbMsgId, this.tbMsgType, (FutureCallback<Void>)Objects.requireNonNullElse(this.callback, NoOpFutureCallback.instance()));
        }
    }
}

