/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api.msg;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKey;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;

public class DeviceAttributesEventNotificationMsg
implements ToDeviceActorNotificationMsg {
    private final TenantId tenantId;
    private final DeviceId deviceId;
    private final Set<AttributeKey> deletedKeys;
    private final String scope;
    private final List<AttributeKvEntry> values;
    private final boolean deleted;

    public static DeviceAttributesEventNotificationMsg onUpdate(TenantId tenantId, DeviceId deviceId, String scope, List<AttributeKvEntry> values) {
        return new DeviceAttributesEventNotificationMsg(tenantId, deviceId, null, scope, values, false);
    }

    public static DeviceAttributesEventNotificationMsg onDelete(TenantId tenantId, DeviceId deviceId, Set<AttributeKey> keys) {
        return new DeviceAttributesEventNotificationMsg(tenantId, deviceId, keys, null, null, true);
    }

    public MsgType getMsgType() {
        return MsgType.DEVICE_ATTRIBUTES_UPDATE_TO_DEVICE_ACTOR_MSG;
    }

    public String toString() {
        return "DeviceAttributesEventNotificationMsg(tenantId=" + this.getTenantId() + ", deviceId=" + this.getDeviceId() + ", deletedKeys=" + this.getDeletedKeys() + ", scope=" + this.getScope() + ", values=" + this.getValues() + ", deleted=" + this.isDeleted() + ")";
    }

    @ConstructorProperties(value={"tenantId", "deviceId", "deletedKeys", "scope", "values", "deleted"})
    public DeviceAttributesEventNotificationMsg(TenantId tenantId, DeviceId deviceId, Set<AttributeKey> deletedKeys, String scope, List<AttributeKvEntry> values, boolean deleted) {
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.deletedKeys = deletedKeys;
        this.scope = scope;
        this.values = values;
        this.deleted = deleted;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public Set<AttributeKey> getDeletedKeys() {
        return this.deletedKeys;
    }

    public String getScope() {
        return this.scope;
    }

    public List<AttributeKvEntry> getValues() {
        return this.values;
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

