/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public class TbNodeUtils {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String METADATA_VARIABLE_TEMPLATE = "${%s}";
    private static final Pattern DATA_PATTERN = Pattern.compile("(\\$\\[)(.*?)(])");
    private static final String DATA_VARIABLE_TEMPLATE = "$[%s]";

    public static <T> T convert(TbNodeConfiguration configuration, Class<T> clazz) throws TbNodeException {
        try {
            return (T)mapper.treeToValue((TreeNode)configuration.getData(), clazz);
        }
        catch (JsonProcessingException e) {
            throw new TbNodeException((Exception)((Object)e));
        }
    }

    public static List<String> processPatterns(List<String> patterns, TbMsg tbMsg) {
        if (!CollectionUtils.isEmpty(patterns)) {
            return patterns.stream().map(p -> TbNodeUtils.processPattern(p, tbMsg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String processPattern(String pattern, TbMsg tbMsg) {
        try {
            String result = TbNodeUtils.processPattern(pattern, tbMsg.getMetaData());
            JsonNode json = mapper.readTree(tbMsg.getData());
            if (json.isObject()) {
                Matcher matcher = DATA_PATTERN.matcher(result);
                while (matcher.find()) {
                    String group = matcher.group(2);
                    String[] keys = group.split("\\.");
                    JsonNode jsonNode = json;
                    for (String key : keys) {
                        if (StringUtils.isEmpty((Object)key) || jsonNode == null) {
                            jsonNode = null;
                            break;
                        }
                        jsonNode = jsonNode.get(key);
                    }
                    if (jsonNode == null || !jsonNode.isValueNode()) continue;
                    result = result.replace(String.format(DATA_VARIABLE_TEMPLATE, group), jsonNode.asText());
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process pattern!", e);
        }
    }

    public static List<String> processPatterns(List<String> patterns, TbMsgMetaData metaData) {
        if (!CollectionUtils.isEmpty(patterns)) {
            return patterns.stream().map(p -> TbNodeUtils.processPattern(p, metaData)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String processPattern(String pattern, TbMsgMetaData metaData) {
        String result = pattern;
        for (Map.Entry keyVal : metaData.values().entrySet()) {
            result = TbNodeUtils.processVar(result, (String)keyVal.getKey(), (String)keyVal.getValue());
        }
        return result;
    }

    private static String processVar(String pattern, String key, String val) {
        String varPattern = String.format(METADATA_VARIABLE_TEMPLATE, key);
        return pattern.replace(varPattern, val);
    }
}

