/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.thingsboard.rule.engine.api.RpcError;
import org.thingsboard.server.common.data.id.DeviceId;

public final class RuleEngineDeviceRpcResponse {
    private final DeviceId deviceId;
    private final int requestId;
    private final Optional<String> response;
    private final Optional<RpcError> error;

    @ConstructorProperties(value={"deviceId", "requestId", "response", "error"})
    RuleEngineDeviceRpcResponse(DeviceId deviceId, int requestId, Optional<String> response, Optional<RpcError> error) {
        this.deviceId = deviceId;
        this.requestId = requestId;
        this.response = response;
        this.error = error;
    }

    public static RuleEngineDeviceRpcResponseBuilder builder() {
        return new RuleEngineDeviceRpcResponseBuilder();
    }

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public Optional<String> getResponse() {
        return this.response;
    }

    public Optional<RpcError> getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleEngineDeviceRpcResponse)) {
            return false;
        }
        RuleEngineDeviceRpcResponse other = (RuleEngineDeviceRpcResponse)o;
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        Optional<String> this$response = this.getResponse();
        Optional<String> other$response = other.getResponse();
        if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
            return false;
        }
        Optional<RpcError> this$error = this.getError();
        Optional<RpcError> other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRequestId();
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        Optional<String> $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        Optional<RpcError> $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public String toString() {
        return "RuleEngineDeviceRpcResponse(deviceId=" + this.getDeviceId() + ", requestId=" + this.getRequestId() + ", response=" + this.getResponse() + ", error=" + this.getError() + ")";
    }

    public static class RuleEngineDeviceRpcResponseBuilder {
        private DeviceId deviceId;
        private int requestId;
        private Optional<String> response;
        private Optional<RpcError> error;

        RuleEngineDeviceRpcResponseBuilder() {
        }

        public RuleEngineDeviceRpcResponseBuilder deviceId(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public RuleEngineDeviceRpcResponseBuilder requestId(int requestId) {
            this.requestId = requestId;
            return this;
        }

        public RuleEngineDeviceRpcResponseBuilder response(Optional<String> response) {
            this.response = response;
            return this;
        }

        public RuleEngineDeviceRpcResponseBuilder error(Optional<RpcError> error) {
            this.error = error;
            return this;
        }

        public RuleEngineDeviceRpcResponse build() {
            return new RuleEngineDeviceRpcResponse(this.deviceId, this.requestId, this.response, this.error);
        }

        public String toString() {
            return "RuleEngineDeviceRpcResponse.RuleEngineDeviceRpcResponseBuilder(deviceId=" + this.deviceId + ", requestId=" + this.requestId + ", response=" + this.response + ", error=" + this.error + ")";
        }
    }
}

