/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import java.beans.ConstructorProperties;
import java.util.UUID;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;

public final class RuleEngineDeviceRpcRequest {
    private final TenantId tenantId;
    private final DeviceId deviceId;
    private final int requestId;
    private final UUID requestUUID;
    private final String originServiceId;
    private final boolean oneway;
    private final String method;
    private final String body;
    private final long expirationTime;
    private final boolean restApiCall;

    @ConstructorProperties(value={"tenantId", "deviceId", "requestId", "requestUUID", "originServiceId", "oneway", "method", "body", "expirationTime", "restApiCall"})
    RuleEngineDeviceRpcRequest(TenantId tenantId, DeviceId deviceId, int requestId, UUID requestUUID, String originServiceId, boolean oneway, String method, String body, long expirationTime, boolean restApiCall) {
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.requestId = requestId;
        this.requestUUID = requestUUID;
        this.originServiceId = originServiceId;
        this.oneway = oneway;
        this.method = method;
        this.body = body;
        this.expirationTime = expirationTime;
        this.restApiCall = restApiCall;
    }

    public static RuleEngineDeviceRpcRequestBuilder builder() {
        return new RuleEngineDeviceRpcRequestBuilder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public UUID getRequestUUID() {
        return this.requestUUID;
    }

    public String getOriginServiceId() {
        return this.originServiceId;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public String getMethod() {
        return this.method;
    }

    public String getBody() {
        return this.body;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isRestApiCall() {
        return this.restApiCall;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleEngineDeviceRpcRequest)) {
            return false;
        }
        RuleEngineDeviceRpcRequest other = (RuleEngineDeviceRpcRequest)o;
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        if (this.isOneway() != other.isOneway()) {
            return false;
        }
        if (this.getExpirationTime() != other.getExpirationTime()) {
            return false;
        }
        if (this.isRestApiCall() != other.isRestApiCall()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        UUID this$requestUUID = this.getRequestUUID();
        UUID other$requestUUID = other.getRequestUUID();
        if (this$requestUUID == null ? other$requestUUID != null : !((Object)this$requestUUID).equals(other$requestUUID)) {
            return false;
        }
        String this$originServiceId = this.getOriginServiceId();
        String other$originServiceId = other.getOriginServiceId();
        if (this$originServiceId == null ? other$originServiceId != null : !this$originServiceId.equals(other$originServiceId)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRequestId();
        result = result * 59 + (this.isOneway() ? 79 : 97);
        long $expirationTime = this.getExpirationTime();
        result = result * 59 + (int)($expirationTime >>> 32 ^ $expirationTime);
        result = result * 59 + (this.isRestApiCall() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        UUID $requestUUID = this.getRequestUUID();
        result = result * 59 + ($requestUUID == null ? 43 : ((Object)$requestUUID).hashCode());
        String $originServiceId = this.getOriginServiceId();
        result = result * 59 + ($originServiceId == null ? 43 : $originServiceId.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "RuleEngineDeviceRpcRequest(tenantId=" + this.getTenantId() + ", deviceId=" + this.getDeviceId() + ", requestId=" + this.getRequestId() + ", requestUUID=" + this.getRequestUUID() + ", originServiceId=" + this.getOriginServiceId() + ", oneway=" + this.isOneway() + ", method=" + this.getMethod() + ", body=" + this.getBody() + ", expirationTime=" + this.getExpirationTime() + ", restApiCall=" + this.isRestApiCall() + ")";
    }

    public static class RuleEngineDeviceRpcRequestBuilder {
        private TenantId tenantId;
        private DeviceId deviceId;
        private int requestId;
        private UUID requestUUID;
        private String originServiceId;
        private boolean oneway;
        private String method;
        private String body;
        private long expirationTime;
        private boolean restApiCall;

        RuleEngineDeviceRpcRequestBuilder() {
        }

        public RuleEngineDeviceRpcRequestBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder deviceId(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder requestId(int requestId) {
            this.requestId = requestId;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder requestUUID(UUID requestUUID) {
            this.requestUUID = requestUUID;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder originServiceId(String originServiceId) {
            this.originServiceId = originServiceId;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder oneway(boolean oneway) {
            this.oneway = oneway;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder body(String body) {
            this.body = body;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder expirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public RuleEngineDeviceRpcRequestBuilder restApiCall(boolean restApiCall) {
            this.restApiCall = restApiCall;
            return this;
        }

        public RuleEngineDeviceRpcRequest build() {
            return new RuleEngineDeviceRpcRequest(this.tenantId, this.deviceId, this.requestId, this.requestUUID, this.originServiceId, this.oneway, this.method, this.body, this.expirationTime, this.restApiCall);
        }

        public String toString() {
            return "RuleEngineDeviceRpcRequest.RuleEngineDeviceRpcRequestBuilder(tenantId=" + this.tenantId + ", deviceId=" + this.deviceId + ", requestId=" + this.requestId + ", requestUUID=" + this.requestUUID + ", originServiceId=" + this.originServiceId + ", oneway=" + this.oneway + ", method=" + this.method + ", body=" + this.body + ", expirationTime=" + this.expirationTime + ", restApiCall=" + this.restApiCall + ")";
        }
    }
}

