/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.dao.alarm.AlarmOperationResult;

public interface RuleEngineAlarmService {
    public Alarm createOrUpdateAlarm(Alarm var1);

    public Boolean deleteAlarm(TenantId var1, AlarmId var2);

    public ListenableFuture<Boolean> ackAlarm(TenantId var1, AlarmId var2, long var3);

    public ListenableFuture<Boolean> clearAlarm(TenantId var1, AlarmId var2, JsonNode var3, long var4);

    public ListenableFuture<AlarmOperationResult> clearAlarmForResult(TenantId var1, AlarmId var2, JsonNode var3, long var4);

    public ListenableFuture<Alarm> findAlarmByIdAsync(TenantId var1, AlarmId var2);

    public ListenableFuture<Alarm> findLatestByOriginatorAndType(TenantId var1, EntityId var2, String var3);

    public ListenableFuture<AlarmInfo> findAlarmInfoByIdAsync(TenantId var1, AlarmId var2);

    public ListenableFuture<PageData<AlarmInfo>> findAlarms(TenantId var1, AlarmQuery var2);

    public AlarmSeverity findHighestAlarmSeverity(TenantId var1, EntityId var2, AlarmSearchStatus var3, AlarmStatus var4);

    public PageData<AlarmData> findAlarmDataByQueryForEntities(TenantId var1, CustomerId var2, AlarmDataQuery var3, Collection<EntityId> var4);
}

