/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api.msg;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.thingsboard.server.common.data.kv.AttributeKey;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;

public class DeviceAttributes {
    private final Map<String, AttributeKvEntry> clientSideAttributesMap;
    private final Map<String, AttributeKvEntry> serverPrivateAttributesMap;
    private final Map<String, AttributeKvEntry> serverPublicAttributesMap;

    public DeviceAttributes(List<AttributeKvEntry> clientSideAttributes, List<AttributeKvEntry> serverPrivateAttributes, List<AttributeKvEntry> serverPublicAttributes) {
        this.clientSideAttributesMap = DeviceAttributes.mapAttributes(clientSideAttributes);
        this.serverPrivateAttributesMap = DeviceAttributes.mapAttributes(serverPrivateAttributes);
        this.serverPublicAttributesMap = DeviceAttributes.mapAttributes(serverPublicAttributes);
    }

    private static Map<String, AttributeKvEntry> mapAttributes(List<AttributeKvEntry> attributes) {
        HashMap<String, AttributeKvEntry> result = new HashMap<String, AttributeKvEntry>();
        for (AttributeKvEntry attribute : attributes) {
            result.put(attribute.getKey(), attribute);
        }
        return result;
    }

    public Collection<AttributeKvEntry> getClientSideAttributes() {
        return this.clientSideAttributesMap.values();
    }

    public Collection<AttributeKvEntry> getServerSideAttributes() {
        return this.serverPrivateAttributesMap.values();
    }

    public Collection<AttributeKvEntry> getServerSidePublicAttributes() {
        return this.serverPublicAttributesMap.values();
    }

    public Optional<AttributeKvEntry> getClientSideAttribute(String attribute) {
        return Optional.ofNullable(this.clientSideAttributesMap.get(attribute));
    }

    public Optional<AttributeKvEntry> getServerPrivateAttribute(String attribute) {
        return Optional.ofNullable(this.serverPrivateAttributesMap.get(attribute));
    }

    public Optional<AttributeKvEntry> getServerPublicAttribute(String attribute) {
        return Optional.ofNullable(this.serverPublicAttributesMap.get(attribute));
    }

    public void remove(AttributeKey key) {
        Map<String, AttributeKvEntry> map = this.getMapByScope(key.getScope());
        if (map != null) {
            map.remove(key);
        }
    }

    public void update(String scope, List<AttributeKvEntry> values) {
        Map<String, AttributeKvEntry> map = this.getMapByScope(scope);
        values.forEach(v -> map.put(v.getKey(), (AttributeKvEntry)v));
    }

    private Map<String, AttributeKvEntry> getMapByScope(String scope) {
        Map<String, AttributeKvEntry> map = null;
        if (scope.equalsIgnoreCase("CLIENT_SCOPE")) {
            map = this.clientSideAttributesMap;
        } else if (scope.equalsIgnoreCase("SHARED_SCOPE")) {
            map = this.serverPublicAttributesMap;
        } else if (scope.equalsIgnoreCase("SERVER_SCOPE")) {
            map = this.serverPrivateAttributesMap;
        }
        return map;
    }

    public String toString() {
        return "DeviceAttributes{clientSideAttributesMap=" + this.clientSideAttributesMap + ", serverPrivateAttributesMap=" + this.serverPrivateAttributesMap + ", serverPublicAttributesMap=" + this.serverPublicAttributesMap + '}';
    }
}

