/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.api;

import io.netty.channel.EventLoopGroup;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.data.redis.core.RedisTemplate;
import org.thingsboard.common.util.ListeningExecutor;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.RuleEngineAlarmService;
import org.thingsboard.rule.engine.api.RuleEngineDeviceProfileCache;
import org.thingsboard.rule.engine.api.RuleEngineRpcService;
import org.thingsboard.rule.engine.api.RuleEngineTelemetryService;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.SmsService;
import org.thingsboard.rule.engine.api.sms.SmsSenderFactory;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.RuleNodeState;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.nosql.CassandraStatementTask;
import org.thingsboard.server.dao.nosql.TbResultSetFuture;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.user.UserService;

public interface TbContext {
    public void tellSuccess(TbMsg var1);

    public void tellNext(TbMsg var1, String var2);

    public void tellNext(TbMsg var1, Set<String> var2);

    public void tellSelf(TbMsg var1, long var2);

    public void tellFailure(TbMsg var1, Throwable var2);

    public void enqueue(TbMsg var1, Runnable var2, Consumer<Throwable> var3);

    public void enqueue(TbMsg var1, String var2, Runnable var3, Consumer<Throwable> var4);

    public void enqueueForTellFailure(TbMsg var1, String var2);

    public void enqueueForTellNext(TbMsg var1, String var2);

    public void enqueueForTellNext(TbMsg var1, Set<String> var2);

    public void enqueueForTellNext(TbMsg var1, String var2, Runnable var3, Consumer<Throwable> var4);

    public void enqueueForTellNext(TbMsg var1, Set<String> var2, Runnable var3, Consumer<Throwable> var4);

    public void enqueueForTellNext(TbMsg var1, String var2, String var3, Runnable var4, Consumer<Throwable> var5);

    public void enqueueForTellNext(TbMsg var1, String var2, Set<String> var3, Runnable var4, Consumer<Throwable> var5);

    public void ack(TbMsg var1);

    public TbMsg newMsg(String var1, String var2, EntityId var3, TbMsgMetaData var4, String var5);

    public TbMsg transformMsg(TbMsg var1, String var2, EntityId var3, TbMsgMetaData var4, String var5);

    public TbMsg customerCreatedMsg(Customer var1, RuleNodeId var2);

    public TbMsg deviceCreatedMsg(Device var1, RuleNodeId var2);

    public TbMsg assetCreatedMsg(Asset var1, RuleNodeId var2);

    public TbMsg alarmActionMsg(Alarm var1, RuleNodeId var2, String var3);

    public boolean isLocalEntity(EntityId var1);

    public RuleNodeId getSelfId();

    public TenantId getTenantId();

    public AttributesService getAttributesService();

    public CustomerService getCustomerService();

    public TenantService getTenantService();

    public UserService getUserService();

    public AssetService getAssetService();

    public DeviceService getDeviceService();

    public DashboardService getDashboardService();

    public RuleEngineAlarmService getAlarmService();

    public RuleChainService getRuleChainService();

    public RuleEngineRpcService getRpcService();

    public RuleEngineTelemetryService getTelemetryService();

    public TimeseriesService getTimeseriesService();

    public RelationService getRelationService();

    public EntityViewService getEntityViewService();

    public RuleEngineDeviceProfileCache getDeviceProfileCache();

    public ListeningExecutor getJsExecutor();

    public ListeningExecutor getMailExecutor();

    public ListeningExecutor getSmsExecutor();

    public ListeningExecutor getDbCallbackExecutor();

    public ListeningExecutor getExternalCallExecutor();

    public MailService getMailService();

    public SmsService getSmsService();

    public SmsSenderFactory getSmsSenderFactory();

    public ScriptEngine createJsScriptEngine(String var1, String ... var2);

    public void logJsEvalRequest();

    public void logJsEvalResponse();

    public void logJsEvalFailure();

    public String getServiceId();

    public EventLoopGroup getSharedEventLoop();

    public CassandraCluster getCassandraCluster();

    public TbResultSetFuture submitCassandraTask(CassandraStatementTask var1);

    @Deprecated
    public RedisTemplate<String, Object> getRedisTemplate();

    public PageData<RuleNodeState> findRuleNodeStates(PageLink var1);

    public RuleNodeState findRuleNodeStateForEntity(EntityId var1);

    public void removeRuleNodeStateForEntity(EntityId var1);

    public RuleNodeState saveRuleNodeState(RuleNodeState var1);

    public void clearRuleNodeStates();

    public void addTenantProfileListener(Consumer<TenantProfile> var1);

    public void addDeviceProfileListeners(Consumer<DeviceProfile> var1, BiConsumer<DeviceId, DeviceProfile> var2);

    public void removeListeners();

    public TenantProfile getTenantProfile();
}

