/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.concurrent.ScheduledFuture;
import java.beans.ConstructorProperties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.mqtt.PendingOperation;

final class RetransmissionHandler<T extends MqttMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetransmissionHandler.class);
    private final MqttClientConfig.RetransmissionConfig config;
    private final PendingOperation pendingOperation;
    private volatile boolean stopped;
    private ScheduledFuture<?> timer;
    private int attemptCount = 0;
    private BiConsumer<MqttFixedHeader, T> handler;
    private final String ownerId;
    private String originalMessageId;
    private long totalWaitingTimeMillis;
    private T originalMessage;

    void setOriginalMessage(T originalMessage) {
        this.originalMessage = originalMessage;
        Object variableHeader = originalMessage.variableHeader();
        if (variableHeader instanceof MqttMessageIdVariableHeader) {
            MqttMessageIdVariableHeader messageIdVariableHeader = (MqttMessageIdVariableHeader)variableHeader;
            this.originalMessageId = String.valueOf(messageIdVariableHeader.messageId());
        } else if (variableHeader instanceof MqttPublishVariableHeader) {
            MqttPublishVariableHeader publishVariableHeader = (MqttPublishVariableHeader)variableHeader;
            this.originalMessageId = String.valueOf(publishVariableHeader.packetId());
        } else {
            this.originalMessageId = "N/A";
        }
    }

    void start(EventLoop eventLoop) {
        if (eventLoop == null) {
            throw new NullPointerException("eventLoop");
        }
        if (this.handler == null) {
            throw new NullPointerException("handler");
        }
        log.debug("{}MessageID[{}] Starting retransmission handler", (Object)this.ownerId, (Object)this.originalMessageId);
        this.startTimer(eventLoop);
    }

    private void startTimer(EventLoop eventLoop) {
        if (this.stopped || this.pendingOperation.isCancelled()) {
            return;
        }
        long baseDelay = this.config.initialDelayMillis() * (long)Math.pow(2.0, this.attemptCount);
        double minFactor = 1.0 - this.config.jitterFactor();
        double maxFactor = 1.0 + this.config.jitterFactor();
        double randomFactor = this.config.jitterFactor() == 0.0 ? 1.0 : ThreadLocalRandom.current().nextDouble(minFactor, maxFactor);
        long delayMillisWithJitter = (long)((double)baseDelay * randomFactor);
        this.totalWaitingTimeMillis += delayMillisWithJitter;
        this.timer = eventLoop.schedule(() -> {
            if (this.stopped || this.pendingOperation.isCancelled()) {
                return;
            }
            ++this.attemptCount;
            if (this.attemptCount > this.config.maxAttempts()) {
                log.debug("{}MessageID[{}] Gave up after {} retransmission attempts; waited a total of {} ms without receiving acknowledgement", new Object[]{this.ownerId, this.originalMessageId, this.config.maxAttempts(), this.totalWaitingTimeMillis});
                this.stop();
                this.pendingOperation.onMaxRetransmissionAttemptsReached();
                return;
            }
            log.debug("{}MessageID[{}] Retransmission attempt #{} out of {}", new Object[]{this.ownerId, this.originalMessageId, this.attemptCount, this.config.maxAttempts()});
            MqttFixedHeader originalFixedHeader = this.originalMessage.fixedHeader();
            MqttFixedHeader newFixedHeader = new MqttFixedHeader(originalFixedHeader.messageType(), RetransmissionHandler.isDup(originalFixedHeader), originalFixedHeader.qosLevel(), originalFixedHeader.isRetain(), originalFixedHeader.remainingLength());
            this.handler.accept(newFixedHeader, (MqttFixedHeader)this.originalMessage);
            this.startTimer(eventLoop);
        }, delayMillisWithJitter, TimeUnit.MILLISECONDS);
    }

    private static boolean isDup(MqttFixedHeader originalFixedHeader) {
        return originalFixedHeader.isDup() || originalFixedHeader.messageType() == MqttMessageType.PUBLISH && originalFixedHeader.qosLevel() != MqttQoS.AT_MOST_ONCE;
    }

    void stop() {
        log.debug("{}MessageID[{}] Stopping retransmission handler", (Object)this.ownerId, (Object)this.originalMessageId);
        this.stopped = true;
        if (this.timer != null) {
            this.timer.cancel(true);
        }
    }

    @ConstructorProperties(value={"config", "pendingOperation", "ownerId"})
    @Generated
    public RetransmissionHandler(MqttClientConfig.RetransmissionConfig config, PendingOperation pendingOperation, String ownerId) {
        this.config = config;
        this.pendingOperation = pendingOperation;
        this.ownerId = ownerId;
    }

    @Generated
    public void setHandler(BiConsumer<MqttFixedHeader, T> handler) {
        this.handler = handler;
    }
}

