/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.mqtt.ReconnectStrategy;

public class ReconnectStrategyExponential
implements ReconnectStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReconnectStrategyExponential.class);
    public static final int DEFAULT_RECONNECT_INTERVAL_SEC = 10;
    public static final int MAX_RECONNECT_INTERVAL_SEC = 60;
    public static final int EXP_MAX = 8;
    public static final long JITTER_MAX = 1L;
    private final long reconnectIntervalMinSeconds;
    private final long reconnectIntervalMaxSeconds;
    private long lastDisconnectNanoTime = 0L;
    private long retryCount = 0L;

    public ReconnectStrategyExponential(long reconnectIntervalMinSeconds) {
        this.reconnectIntervalMaxSeconds = this.calculateIntervalMax(reconnectIntervalMinSeconds);
        this.reconnectIntervalMinSeconds = this.calculateIntervalMin(reconnectIntervalMinSeconds);
    }

    long calculateIntervalMax(long reconnectIntervalMinSeconds) {
        return reconnectIntervalMinSeconds > 60L ? reconnectIntervalMinSeconds : 60L;
    }

    long calculateIntervalMin(long reconnectIntervalMinSeconds) {
        return Math.min(reconnectIntervalMinSeconds > 0L ? reconnectIntervalMinSeconds : 10L, this.reconnectIntervalMaxSeconds);
    }

    @Override
    public synchronized long getNextReconnectDelay() {
        long currentNanoTime = this.getNanoTime();
        long coolDownSpentNanos = currentNanoTime - this.lastDisconnectNanoTime;
        this.lastDisconnectNanoTime = currentNanoTime;
        if (this.isCooledDown(coolDownSpentNanos)) {
            this.retryCount = 0L;
            return this.reconnectIntervalMinSeconds;
        }
        return this.calculateNextReconnectDelay() + this.calculateJitter();
    }

    long calculateJitter() {
        return ThreadLocalRandom.current().nextInt() >= 0 ? 1L : 0L;
    }

    long calculateNextReconnectDelay() {
        return Math.min(this.reconnectIntervalMaxSeconds, this.reconnectIntervalMinSeconds + this.calculateExp(this.retryCount++));
    }

    long calculateExp(long e) {
        return 1L << (int)Math.min(e, 8L);
    }

    boolean isCooledDown(long coolDownSpentNanos) {
        return TimeUnit.NANOSECONDS.toSeconds(coolDownSpentNanos) > this.reconnectIntervalMaxSeconds + this.reconnectIntervalMinSeconds;
    }

    long getNanoTime() {
        return System.nanoTime();
    }

    @Generated
    public long getReconnectIntervalMinSeconds() {
        return this.reconnectIntervalMinSeconds;
    }

    @Generated
    public long getReconnectIntervalMaxSeconds() {
        return this.reconnectIntervalMaxSeconds;
    }

    @Generated
    public long getLastDisconnectNanoTime() {
        return this.lastDisconnectNanoTime;
    }

    @Generated
    public long getRetryCount() {
        return this.retryCount;
    }
}

