/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import java.util.regex.Pattern;
import lombok.Generated;
import org.thingsboard.mqtt.MqttHandler;

final class MqttSubscription {
    private final String topic;
    private final Pattern topicRegex;
    private final MqttHandler handler;
    private final boolean once;
    private volatile boolean called;

    MqttSubscription(String topic, MqttHandler handler, boolean once) {
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.topic = topic;
        this.handler = handler;
        this.once = once;
        this.topicRegex = Pattern.compile(topic.replace("+", "[^/]+").replace("#", ".+") + "$");
    }

    boolean matches(String topic) {
        return this.topicRegex.matcher(topic).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttSubscription that = (MqttSubscription)o;
        return this.once == that.once && this.topic.equals(that.topic) && this.handler.equals(that.handler);
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.handler.hashCode();
        result = 31 * result + (this.once ? 1 : 0);
        return result;
    }

    @Generated
    String getTopic() {
        return this.topic;
    }

    @Generated
    public MqttHandler getHandler() {
        return this.handler;
    }

    @Generated
    boolean isOnce() {
        return this.once;
    }

    @Generated
    boolean isCalled() {
        return this.called;
    }

    @Generated
    void setCalled(boolean called) {
        this.called = called;
    }
}

