/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MqttPingHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttPingHandler.class);
    private final int keepaliveSeconds;
    private ScheduledFuture<?> pingRespTimeout;

    MqttPingHandler(int keepaliveSeconds) {
        this.keepaliveSeconds = keepaliveSeconds;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof MqttMessage)) {
            ctx.fireChannelRead(msg);
            return;
        }
        MqttMessage message = (MqttMessage)msg;
        if (message.fixedHeader().messageType() == MqttMessageType.PINGREQ) {
            this.handlePingReq(ctx.channel());
        } else if (message.fixedHeader().messageType() == MqttMessageType.PINGRESP) {
            this.handlePingResp(ctx.channel());
        } else {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            switch (event.state()) {
                case READER_IDLE: {
                    log.debug("[{}] No reads were performed for specified period for channel {}", (Object)event.state(), (Object)ctx.channel().id());
                    this.sendPingReq(ctx.channel(), event);
                    break;
                }
                case WRITER_IDLE: {
                    log.debug("[{}] No writes were performed for specified period for channel {}", (Object)event.state(), (Object)ctx.channel().id());
                    this.sendPingReq(ctx.channel(), event);
                }
            }
        }
    }

    private void sendPingReq(Channel channel, IdleStateEvent idleEvent) {
        log.trace("[{}] Sending ping request", (Object)channel.id());
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PINGREQ, false, MqttQoS.AT_MOST_ONCE, false, 0);
        channel.writeAndFlush((Object)new MqttMessage(fixedHeader));
        if (this.pingRespTimeout == null) {
            log.trace("[{}] Scheduling disconnect due to {}", (Object)channel.id(), (Object)idleEvent);
            this.pingRespTimeout = channel.eventLoop().schedule(() -> {
                log.trace("[{}] Sending disconnect due to {}", (Object)channel.id(), (Object)idleEvent);
                MqttFixedHeader fixedHeader2 = new MqttFixedHeader(MqttMessageType.DISCONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
                channel.writeAndFlush((Object)new MqttMessage(fixedHeader2)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }, (long)this.keepaliveSeconds, TimeUnit.SECONDS);
        }
    }

    private void handlePingReq(Channel channel) {
        log.trace("[{}] Handling ping request", (Object)channel.id());
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        channel.writeAndFlush((Object)new MqttMessage(fixedHeader));
    }

    private void handlePingResp(Channel channel) {
        log.trace("[{}] Handling ping response", (Object)channel.id());
        if (this.pingRespTimeout != null && !this.pingRespTimeout.isCancelled() && !this.pingRespTimeout.isDone()) {
            log.trace("[{}] Cancelling disconnect due to idle event because ping response was received", (Object)channel.id());
            this.pingRespTimeout.cancel(true);
            this.pingRespTimeout = null;
        }
    }
}

