/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.util.concurrent.Promise;
import java.util.function.Consumer;
import lombok.Generated;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.mqtt.PendingOperation;
import org.thingsboard.mqtt.RetransmissionHandler;

final class MqttPendingUnsubscription {
    private final Promise<Void> future;
    private final String topic;
    private final RetransmissionHandler<MqttUnsubscribeMessage> retransmissionHandler;

    private MqttPendingUnsubscription(Promise<Void> future, String topic, MqttUnsubscribeMessage unsubscribeMessage, String ownerId, MqttClientConfig.RetransmissionConfig retransmissionConfig, PendingOperation operation) {
        this.future = future;
        this.topic = topic;
        this.retransmissionHandler = new RetransmissionHandler(retransmissionConfig, operation, ownerId);
        this.retransmissionHandler.setOriginalMessage(unsubscribeMessage);
    }

    void startRetransmissionTimer(EventLoop eventLoop, Consumer<Object> sendPacket) {
        this.retransmissionHandler.setHandler((fixedHeader, originalMessage) -> sendPacket.accept(new MqttUnsubscribeMessage(fixedHeader, originalMessage.variableHeader(), originalMessage.payload())));
        this.retransmissionHandler.start(eventLoop);
    }

    void onUnsubackReceived() {
        this.retransmissionHandler.stop();
    }

    void onChannelClosed() {
        this.retransmissionHandler.stop();
    }

    static Builder builder() {
        return new Builder();
    }

    @Generated
    Promise<Void> getFuture() {
        return this.future;
    }

    @Generated
    String getTopic() {
        return this.topic;
    }

    static class Builder {
        private Promise<Void> future;
        private String topic;
        private MqttUnsubscribeMessage unsubscribeMessage;
        private String ownerId;
        private PendingOperation pendingOperation;
        private MqttClientConfig.RetransmissionConfig retransmissionConfig;

        Builder() {
        }

        Builder future(Promise<Void> future) {
            this.future = future;
            return this;
        }

        Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        Builder unsubscribeMessage(MqttUnsubscribeMessage unsubscribeMessage) {
            this.unsubscribeMessage = unsubscribeMessage;
            return this;
        }

        Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        Builder retransmissionConfig(MqttClientConfig.RetransmissionConfig retransmissionConfig) {
            this.retransmissionConfig = retransmissionConfig;
            return this;
        }

        Builder pendingOperation(PendingOperation pendingOperation) {
            this.pendingOperation = pendingOperation;
            return this;
        }

        MqttPendingUnsubscription build() {
            return new MqttPendingUnsubscription(this.future, this.topic, this.unsubscribeMessage, this.ownerId, this.retransmissionConfig, this.pendingOperation);
        }
    }
}

