/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.util.concurrent.Promise;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.mqtt.MqttHandler;
import org.thingsboard.mqtt.PendingOperation;
import org.thingsboard.mqtt.RetransmissionHandler;

final class MqttPendingSubscription {
    private final Promise<Void> future;
    private final String topic;
    private final Set<MqttPendingHandler> handlers;
    private final MqttSubscribeMessage subscribeMessage;
    private final RetransmissionHandler<MqttSubscribeMessage> retransmissionHandler;
    private boolean sent = false;

    private MqttPendingSubscription(Promise<Void> future, String topic, Set<MqttPendingHandler> handlers, MqttSubscribeMessage subscribeMessage, String ownerId, MqttClientConfig.RetransmissionConfig retransmissionConfig, PendingOperation operation) {
        this.future = future;
        this.topic = topic;
        this.handlers = Objects.requireNonNullElseGet(handlers, HashSet::new);
        this.subscribeMessage = subscribeMessage;
        this.retransmissionHandler = new RetransmissionHandler(retransmissionConfig, operation, ownerId);
        this.retransmissionHandler.setOriginalMessage(subscribeMessage);
    }

    void addHandler(MqttHandler handler, boolean once) {
        this.handlers.add(new MqttPendingHandler(handler, once));
    }

    void startRetransmitTimer(EventLoop eventLoop, Consumer<Object> sendPacket) {
        if (this.sent) {
            this.retransmissionHandler.setHandler((fixedHeader, originalMessage) -> sendPacket.accept(new MqttSubscribeMessage(fixedHeader, originalMessage.variableHeader(), originalMessage.payload())));
            this.retransmissionHandler.start(eventLoop);
        }
    }

    void onSubackReceived() {
        this.retransmissionHandler.stop();
    }

    void onChannelClosed() {
        this.retransmissionHandler.stop();
    }

    static Builder builder() {
        return new Builder();
    }

    @Generated
    Promise<Void> getFuture() {
        return this.future;
    }

    @Generated
    String getTopic() {
        return this.topic;
    }

    @Generated
    Set<MqttPendingHandler> getHandlers() {
        return this.handlers;
    }

    @Generated
    MqttSubscribeMessage getSubscribeMessage() {
        return this.subscribeMessage;
    }

    @Generated
    boolean isSent() {
        return this.sent;
    }

    @Generated
    void setSent(boolean sent) {
        this.sent = sent;
    }

    record MqttPendingHandler(MqttHandler handler, boolean once) {
    }

    static class Builder {
        private Promise<Void> future;
        private String topic;
        private Set<MqttPendingHandler> handlers;
        private MqttSubscribeMessage subscribeMessage;
        private String ownerId;
        private PendingOperation pendingOperation;
        private MqttClientConfig.RetransmissionConfig retransmissionConfig;

        Builder() {
        }

        Builder future(Promise<Void> future) {
            this.future = future;
            return this;
        }

        Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        Builder handlers(Set<MqttPendingHandler> handlers) {
            this.handlers = handlers;
            return this;
        }

        Builder subscribeMessage(MqttSubscribeMessage subscribeMessage) {
            this.subscribeMessage = subscribeMessage;
            return this;
        }

        Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        Builder retransmissionConfig(MqttClientConfig.RetransmissionConfig retransmissionConfig) {
            this.retransmissionConfig = retransmissionConfig;
            return this;
        }

        Builder pendingOperation(PendingOperation pendingOperation) {
            this.pendingOperation = pendingOperation;
            return this;
        }

        MqttPendingSubscription build() {
            return new MqttPendingSubscription(this.future, this.topic, this.handlers, this.subscribeMessage, this.ownerId, this.retransmissionConfig, this.pendingOperation);
        }
    }
}

