/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.concurrent.Promise;
import java.util.function.Consumer;
import lombok.Generated;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.mqtt.PendingOperation;
import org.thingsboard.mqtt.RetransmissionHandler;

final class MqttPendingPublish {
    private final int messageId;
    private final Promise<Void> future;
    private final ByteBuf payload;
    private final MqttPublishMessage message;
    private final MqttQoS qos;
    private final RetransmissionHandler<MqttPublishMessage> publishRetransmissionHandler;
    private final RetransmissionHandler<MqttMessage> pubrelRetransmissionHandler;
    private boolean sent = false;

    private MqttPendingPublish(int messageId, Promise<Void> future, ByteBuf payload, MqttPublishMessage message, MqttQoS qos, String ownerId, MqttClientConfig.RetransmissionConfig retransmissionConfig, PendingOperation pendingOperation) {
        this.messageId = messageId;
        this.future = future;
        this.payload = payload;
        this.message = message;
        this.qos = qos;
        this.publishRetransmissionHandler = new RetransmissionHandler(retransmissionConfig, pendingOperation, ownerId);
        this.publishRetransmissionHandler.setOriginalMessage(message);
        this.pubrelRetransmissionHandler = new RetransmissionHandler(retransmissionConfig, pendingOperation, ownerId);
    }

    void startPublishRetransmissionTimer(EventLoop eventLoop, Consumer<Object> sendPacket) {
        this.publishRetransmissionHandler.setHandler((fixedHeader, originalMessage) -> sendPacket.accept(new MqttPublishMessage(fixedHeader, originalMessage.variableHeader(), this.payload.retain())));
        this.publishRetransmissionHandler.start(eventLoop);
    }

    void onPubackReceived() {
        this.publishRetransmissionHandler.stop();
    }

    void setPubrelMessage(MqttMessage pubrelMessage) {
        this.pubrelRetransmissionHandler.setOriginalMessage(pubrelMessage);
    }

    void startPubrelRetransmissionTimer(EventLoop eventLoop, Consumer<Object> sendPacket) {
        this.pubrelRetransmissionHandler.setHandler((fixedHeader, originalMessage) -> sendPacket.accept(new MqttMessage(fixedHeader, originalMessage.variableHeader())));
        this.pubrelRetransmissionHandler.start(eventLoop);
    }

    void onPubcompReceived() {
        this.pubrelRetransmissionHandler.stop();
    }

    void onChannelClosed() {
        this.publishRetransmissionHandler.stop();
        this.pubrelRetransmissionHandler.stop();
        if (this.payload != null) {
            this.payload.release();
        }
    }

    static Builder builder() {
        return new Builder();
    }

    @Generated
    int getMessageId() {
        return this.messageId;
    }

    @Generated
    Promise<Void> getFuture() {
        return this.future;
    }

    @Generated
    ByteBuf getPayload() {
        return this.payload;
    }

    @Generated
    MqttPublishMessage getMessage() {
        return this.message;
    }

    @Generated
    MqttQoS getQos() {
        return this.qos;
    }

    @Generated
    boolean isSent() {
        return this.sent;
    }

    @Generated
    void setSent(boolean sent) {
        this.sent = sent;
    }

    static class Builder {
        private int messageId;
        private Promise<Void> future;
        private ByteBuf payload;
        private MqttPublishMessage message;
        private MqttQoS qos;
        private String ownerId;
        private MqttClientConfig.RetransmissionConfig retransmissionConfig;
        private PendingOperation pendingOperation;

        Builder() {
        }

        Builder messageId(int messageId) {
            this.messageId = messageId;
            return this;
        }

        Builder future(Promise<Void> future) {
            this.future = future;
            return this;
        }

        Builder payload(ByteBuf payload) {
            this.payload = payload;
            return this;
        }

        Builder message(MqttPublishMessage message) {
            this.message = message;
            return this;
        }

        Builder qos(MqttQoS qos) {
            this.qos = qos;
            return this;
        }

        Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        Builder retransmissionConfig(MqttClientConfig.RetransmissionConfig retransmissionConfig) {
            this.retransmissionConfig = retransmissionConfig;
            return this;
        }

        Builder pendingOperation(PendingOperation pendingOperation) {
            this.pendingOperation = pendingOperation;
            return this;
        }

        MqttPendingPublish build() {
            return new MqttPendingPublish(this.messageId, this.future, this.payload, this.message, this.qos, this.ownerId, this.retransmissionConfig, this.pendingOperation);
        }
    }
}

