/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;

public final class MqttLastWill {
    private final String topic;
    private final String message;
    private final boolean retain;
    private final MqttQoS qos;

    public MqttLastWill(String topic, String message, boolean retain, MqttQoS qos) {
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (qos == null) {
            throw new NullPointerException("qos");
        }
        this.topic = topic;
        this.message = message;
        this.retain = retain;
        this.qos = qos;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public MqttQoS getQos() {
        return this.qos;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttLastWill that = (MqttLastWill)o;
        if (this.retain != that.retain) {
            return false;
        }
        if (!this.topic.equals(that.topic)) {
            return false;
        }
        if (!this.message.equals(that.message)) {
            return false;
        }
        return this.qos == that.qos;
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + (this.retain ? 1 : 0);
        result = 31 * result + this.qos.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MqttLastWill{");
        sb.append("topic='").append(this.topic).append('\'');
        sb.append(", message='").append(this.message).append('\'');
        sb.append(", retain=").append(this.retain);
        sb.append(", qos=").append(this.qos.name());
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder {
        private String topic;
        private String message;
        private boolean retain;
        private MqttQoS qos;

        public String getTopic() {
            return this.topic;
        }

        public Builder setTopic(String topic) {
            if (topic == null) {
                throw new NullPointerException("topic");
            }
            this.topic = topic;
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public Builder setMessage(String message) {
            if (message == null) {
                throw new NullPointerException("message");
            }
            this.message = message;
            return this;
        }

        public boolean isRetain() {
            return this.retain;
        }

        public Builder setRetain(boolean retain) {
            this.retain = retain;
            return this;
        }

        public MqttQoS getQos() {
            return this.qos;
        }

        public Builder setQos(MqttQoS qos) {
            if (qos == null) {
                throw new NullPointerException("qos");
            }
            this.qos = qos;
            return this;
        }

        public MqttLastWill build() {
            return new MqttLastWill(this.topic, this.message, this.retain, this.qos);
        }
    }
}

