/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import io.netty.channel.Channel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.handler.ssl.SslContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Random;
import lombok.Generated;
import org.thingsboard.mqtt.MqttLastWill;

public final class MqttClientConfig {
    private final SslContext sslContext;
    private final String randomClientId;
    private String ownerId;
    @Nonnull
    private String clientId;
    private int timeoutSeconds = 60;
    private MqttVersion protocolVersion = MqttVersion.MQTT_3_1;
    @Nullable
    private String username = null;
    @Nullable
    private String password = null;
    private boolean cleanSession = true;
    @Nullable
    private MqttLastWill lastWill;
    private Class<? extends Channel> channelClass = NioSocketChannel.class;
    private boolean reconnect = true;
    private long reconnectDelay = 1L;
    private int maxBytesInMessage = 8092;
    private RetransmissionConfig retransmissionConfig;

    public MqttClientConfig() {
        this(null);
    }

    public MqttClientConfig(SslContext sslContext) {
        this.sslContext = sslContext;
        Random random = new Random();
        StringBuilder id = new StringBuilder("netty-mqtt/");
        String[] options = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".split("");
        for (int i = 0; i < 8; ++i) {
            id.append(options[random.nextInt(options.length)]);
        }
        this.clientId = id.toString();
        this.randomClientId = id.toString();
    }

    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId == null ? this.randomClientId : clientId;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        if (timeoutSeconds != -1 && timeoutSeconds <= 0) {
            throw new IllegalArgumentException("timeoutSeconds must be > 0 or -1");
        }
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setProtocolVersion(MqttVersion protocolVersion) {
        if (protocolVersion == null) {
            throw new NullPointerException("protocolVersion");
        }
        this.protocolVersion = protocolVersion;
    }

    public void setReconnectDelay(long reconnectDelay) {
        if (reconnectDelay <= 0L) {
            throw new IllegalArgumentException("reconnectDelay must be > 0");
        }
        this.reconnectDelay = reconnectDelay;
    }

    public void setMaxBytesInMessage(int maxBytesInMessage) {
        if (maxBytesInMessage <= 0 || maxBytesInMessage > 256000000) {
            throw new IllegalArgumentException("maxBytesInMessage must be > 0 or < 256_000_000");
        }
        this.maxBytesInMessage = maxBytesInMessage;
    }

    @Generated
    public SslContext getSslContext() {
        return this.sslContext;
    }

    @Generated
    public String getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @Nonnull
    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Generated
    public MqttVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Nullable
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Nullable
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    @Generated
    public boolean isCleanSession() {
        return this.cleanSession;
    }

    @Generated
    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    @Nullable
    @Generated
    public MqttLastWill getLastWill() {
        return this.lastWill;
    }

    @Generated
    public void setLastWill(@Nullable MqttLastWill lastWill) {
        this.lastWill = lastWill;
    }

    @Generated
    public void setChannelClass(Class<? extends Channel> channelClass) {
        this.channelClass = channelClass;
    }

    @Generated
    public Class<? extends Channel> getChannelClass() {
        return this.channelClass;
    }

    @Generated
    public boolean isReconnect() {
        return this.reconnect;
    }

    @Generated
    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    @Generated
    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    @Generated
    public int getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    @Generated
    public RetransmissionConfig getRetransmissionConfig() {
        return this.retransmissionConfig;
    }

    @Generated
    public void setRetransmissionConfig(RetransmissionConfig retransmissionConfig) {
        this.retransmissionConfig = retransmissionConfig;
    }

    public record RetransmissionConfig(int maxAttempts, long initialDelayMillis, double jitterFactor) {
        public RetransmissionConfig {
            if (maxAttempts < 0) {
                throw new IllegalArgumentException("Max retransmission attempts (maxAttempts) must be zero or greater, but was " + maxAttempts);
            }
            if (initialDelayMillis < 0L) {
                throw new IllegalArgumentException("Initial retransmission delay (initialDelayMillis) must be zero or greater, but was " + initialDelayMillis);
            }
            if (jitterFactor < 0.0) {
                throw new IllegalArgumentException("Jitter factor (jitterFactor) must be zero or greater, but was " + jitterFactor);
            }
        }
    }
}

