/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import org.thingsboard.common.util.ListeningExecutor;
import org.thingsboard.mqtt.MqttClientCallback;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.mqtt.MqttClientImpl;
import org.thingsboard.mqtt.MqttConnectResult;
import org.thingsboard.mqtt.MqttHandler;

public interface MqttClient {
    public Promise<MqttConnectResult> connect(String var1);

    public Promise<MqttConnectResult> connect(String var1, int var2);

    public boolean isConnected();

    public Promise<MqttConnectResult> reconnect();

    public EventLoopGroup getEventLoop();

    public void setEventLoop(EventLoopGroup var1);

    public ListeningExecutor getHandlerExecutor();

    public Future<Void> on(String var1, MqttHandler var2);

    public Future<Void> on(String var1, MqttHandler var2, MqttQoS var3);

    public Future<Void> once(String var1, MqttHandler var2);

    public Future<Void> once(String var1, MqttHandler var2, MqttQoS var3);

    public Future<Void> off(String var1, MqttHandler var2);

    public Future<Void> off(String var1);

    public Future<Void> publish(String var1, ByteBuf var2);

    public Future<Void> publish(String var1, ByteBuf var2, MqttQoS var3);

    public Future<Void> publish(String var1, ByteBuf var2, boolean var3);

    public Future<Void> publish(String var1, ByteBuf var2, MqttQoS var3, boolean var4);

    public MqttClientConfig getClientConfig();

    public static MqttClient create(MqttClientConfig config, MqttHandler defaultHandler, ListeningExecutor handlerExecutor) {
        return new MqttClientImpl(config, defaultHandler, handlerExecutor);
    }

    public void disconnect();

    public void setCallback(MqttClientCallback var1);
}

