/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.integration.impl;

import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.monitoring.config.integration.HttpIntegrationMonitoringConfig;
import org.thingsboard.monitoring.config.integration.IntegrationMonitoringTarget;
import org.thingsboard.monitoring.config.integration.IntegrationType;
import org.thingsboard.monitoring.service.integration.IntegrationHealthChecker;

@Service
@Scope(value="prototype")
public class HttpIntegrationHealthChecker
extends IntegrationHealthChecker<HttpIntegrationMonitoringConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpIntegrationHealthChecker.class);
    private RestTemplate restTemplate;

    public HttpIntegrationHealthChecker(HttpIntegrationMonitoringConfig config, IntegrationMonitoringTarget target) {
        super(config, target);
    }

    @Override
    protected void initClient() throws Exception {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(Duration.ofMillis(((HttpIntegrationMonitoringConfig)this.config).getRequestTimeoutMs())).setReadTimeout(Duration.ofMillis(((HttpIntegrationMonitoringConfig)this.config).getRequestTimeoutMs())).build();
            log.debug("Initialized HTTP client");
        }
    }

    @Override
    protected void sendTestPayload(String payload) throws Exception {
        String endpoint = ((IntegrationMonitoringTarget)this.target).getIntegration().getConfiguration().get("httpEndpoint").asText();
        this.restTemplate.postForObject(endpoint, (Object)payload, String.class, new Object[0]);
    }

    @Override
    protected void destroyClient() throws Exception {
    }

    @Override
    protected IntegrationType getIntegrationType() {
        return IntegrationType.HTTP;
    }
}

