/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.integration.impl;

import java.io.IOException;
import lombok.Generated;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.thingsboard.monitoring.config.integration.CoapIntegrationMonitoringConfig;
import org.thingsboard.monitoring.config.integration.IntegrationMonitoringTarget;
import org.thingsboard.monitoring.config.integration.IntegrationType;
import org.thingsboard.monitoring.service.integration.IntegrationHealthChecker;

@Service
@Scope(value="prototype")
public class CoapIntegrationHealthChecker
extends IntegrationHealthChecker<CoapIntegrationMonitoringConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoapIntegrationHealthChecker.class);
    private CoapClient coapClient;

    public CoapIntegrationHealthChecker(CoapIntegrationMonitoringConfig config, IntegrationMonitoringTarget target) {
        super(config, target);
    }

    @Override
    protected void initClient() throws Exception {
        if (this.coapClient == null) {
            String uri = ((IntegrationMonitoringTarget)this.target).getIntegration().getConfiguration().get("clientConfiguration").get("coapEndpoint").asText();
            this.coapClient = new CoapClient(uri);
            this.coapClient.setTimeout(Long.valueOf(((CoapIntegrationMonitoringConfig)this.config).getRequestTimeoutMs()));
            log.debug("Initialized CoAP client for URI {}", (Object)uri);
        }
    }

    @Override
    protected void sendTestPayload(String payload) throws Exception {
        CoapResponse response = this.coapClient.post(payload, 50);
        CoAP.ResponseCode code = response.getCode();
        if (code.codeClass != CoAP.CodeClass.SUCCESS_RESPONSE.value) {
            throw new IOException("COAP client didn't receive success response from server");
        }
    }

    @Override
    protected void destroyClient() throws Exception {
        if (this.coapClient != null) {
            this.coapClient.shutdown();
            this.coapClient = null;
            log.info("Disconnected CoAP client");
        }
    }

    @Override
    protected IntegrationType getIntegrationType() {
        return IntegrationType.COAP;
    }
}

