/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.data.notification;

import java.util.Collection;
import org.thingsboard.monitoring.data.Latency;
import org.thingsboard.monitoring.data.notification.Notification;

public class HighLatencyNotification
implements Notification {
    private final Collection<Latency> highLatencies;
    private final int thresholdMs;

    public HighLatencyNotification(Collection<Latency> highLatencies, int thresholdMs) {
        this.highLatencies = highLatencies;
        this.thresholdMs = thresholdMs;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Some of the latencies are higher than ").append(this.thresholdMs).append(" ms:\n");
        this.highLatencies.forEach(latency -> text.append(String.format("[%s] *%s*\n", latency.getKey(), latency.getFormattedValue())));
        return text.toString();
    }
}

