/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.client;

import jakarta.annotation.PostConstruct;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.stereotype.Component;
import org.thingsboard.rest.client.RestClient;

@Component
public class TbClient
extends RestClient {
    @Value(value="${monitoring.rest.username}")
    private String username;
    @Value(value="${monitoring.rest.password}")
    private String password;

    public TbClient(@Value(value="${monitoring.rest.base_url}") String baseUrl, @Value(value="${monitoring.rest.request_timeout_ms}") int requestTimeoutMs) {
        super(new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(Duration.ofMillis(requestTimeoutMs)).setReadTimeout(Duration.ofMillis(requestTimeoutMs)).build(), baseUrl);
    }

    @PostConstruct
    private void init() {
        this.logIn();
    }

    public String logIn() {
        this.login(this.username, this.password);
        return this.getToken();
    }
}

